/*
 *  Analyzer.h
 */
#ifndef __MPEG2_TS_ANALYZER_H__
#define __MPEG2_TS_ANALYZER_H__

#include "MPEG2/TS/Header.h"
#include "MPEG2/TS/PAT.h"
#include "MPEG2/TS/PMT.h"
#include "MPEG2/TS/SDT.h"

namespace MPEG2
{
namespace TS
{

enum
{
    PACKET_TYPE_PAT = 0x00,
    PACKET_TYPE_PMT = 0x02,
    PACKET_TYPE_PCR = 0x04,
    PACKET_TYPE_ES  = 0x08
};

class Analyzer
{
public:
    class Delegate
    {
    public:
        virtual void detect(PAT *) {};
        virtual void detect(PMT *) {};
        virtual void detect(SDT *) {};
        virtual void packet(uint8_t packet_type, uint8_t *buf) {};
        virtual void packet(uint8_t packet_type, uint16_t program_number, uint8_t *buf) {};
        virtual void packet(uint8_t packet_type, uint16_t program_number, uint8_t stream_type, uint8_t *buf) {};
    };

    enum 
    {
        FLAG_PAT = 0x00000001,
        FLAG_SDT = 0x00000002
    };


private:
    Delegate *          _delegate;
    uint32_t            _flag;
    PAT *               _pat;
    SDT *               _sdt;

    class PMT_LIST
    {
    public:
        uint16_t        _program_number;
        uint16_t        _pid;
        PMT *           _pmt;
        PMT_LIST *      _prev;
        PMT_LIST *      _next;

        PMT_LIST(uint16_t program_number, uint16_t pid);
        ~PMT_LIST();
        void add(uint16_t program_number, uint16_t pid);
    };
    PMT_LIST *          _pmt_list;


public:
    Analyzer(Delegate *delegate);
    ~Analyzer();
    void setEnableSDT(bool onoff);
    void put(uint8_t *buf, int32_t length);
};

} // TS
} // MPEG2
#endif