/*
 *  Properties.h
 */

#ifndef __PROPERTIES_H__
#define __PROPERTIES_H__


#ifdef __PROPERTIES_IMPL__
#import <Cocoa/Cocoa.h>
#define __DICTIONARY_IMPL__
#endif
#include "Dictionary.h"

class Properties : public Dictionary
{
private:
    // attributes
    char *_path;

    // methods
    void update();

public:
    Properties();
    ~Properties();
    bool init(const char *path);

    bool setIntegerForKey(int value, const char *key);
    bool setDictionaryForKey(Dictionary *dictionary, const char *key);
    bool setBoolForKey(bool value, const char *key);
    bool setStringForKey(const char *str, const char *key);
    bool setStringWithEncodingForKey(const char *str, const char *encoding, const char *key);
};

#endif