/*
 *  Tuner.h
 */
#ifndef __PTX_PTXD_TUNER_H__
#define __PTX_PTXD_TUNER_H__

#include <pthread.h>
#include <string.h>


#include "PTx/PT1.h"
#include "MPEG2/TS/Analyzer.h"

#include "Dictionary.h"

namespace PTx
{
namespace PTxD
{

#define kPT1PageSize                4096
#define kPT1PageCount               47
#define kPT1PacketSize              188

#define kPT1VirtualSize             4
#define kPT1VirtualCount            16
#define kPT1LockSize                4
#define kPT1BufferPageCount         511
#define kPT1BlockCount              2
#define kPT1BlockSize               (kPT1PageSize * kPT1BufferPageCount / kPT1BlockCount)

class Tuner : public MPEG2::TS::Analyzer::Delegate
{
public:
    class Core
    {
    protected:
        PT1 *           _pt1;
        uint8_t         _retainCount;
        pthread_mutex_t _lock;
        Tuner *         _child[MAX_TUNER_COUNT];
        char *          _name[MAX_TUNER_COUNT];

        // for Tuner Status
        LnbPower        _lnbPower;
        uint32_t        _channel[MAX_TUNER_COUNT];
        bool            _locked[MAX_TUNER_COUNT];

        // for DMA Transfer
        int             _transfer;
        uint            _virtualIndex;
        uint            _imageIndex;
        uint            _blockIndex;
        uint8_t         _buffer[kPT1BlockSize];

        uint offset(uint imageIndex, uint blockIndex, uint additionalOffset);
        uint offset(uint imageIndex, uint blockIndex);
        uint read(uint virtualIndex, uint imageIndex, uint blockIndex);
        void clearBlock(uint virtualIndex, uint imageIndex, uint blockIndex);
        bool waitBlock();
        void copyBlock();
        bool dispatchBlock();

    public:
        Core();
        ~Core();
        bool init(PT1 *pt1);
        virtual void run();
        void setTuner(Tuner *t, uint32_t tuner);
        void retain();
        void release();
        virtual bool setChannel(uint32_t channel, uint32_t tuner);
        virtual uint32_t channel(uint32_t tuner);
        virtual const char *name(uint32_t tuner);
    };


private:
    Core *          _core;
    uint32_t        _tuner;

    // for Stream
    uint            _count;
    uint            _packetCount;
    uint            _packetOffset;
    uint8_t         _buffer[kPT1PageSize * kPT1PageCount];


    pthread_mutex_t         _lock;
    pthread_cond_t          _cond;
    MPEG2::TS::Analyzer *   _analyzer;
    int                     _recfd;
    Dictionary *            _stationInfo;
    char *                  _lockKey;

    Tuner();
    ~Tuner();
    bool init(uint32_t tuner, Core *core);
    void addPacket(uint packet);

public:
    static int scan(Tuner *tuners[MAX_DEV_COUNT * MAX_TUNER_COUNT]);
    bool setChannel(int channel);
    int channel();
    const char *name();
    ISDB isdb();
    Dictionary *stationInfo();
    bool setRecording(int fd);
    bool lock(char *key);
    bool unlock(char *key);
    bool isLocked(char *key);

    // for Analyzer::Delegate
    void detect(MPEG2::TS::PAT *pat);
    void detect(MPEG2::TS::SDT *sdt);
    void packet(uint8_t packet_type, uint8_t *buf);
    void packet(uint8_t packet_type, uint16_t program_number, uint8_t *buf);
    void packet(uint8_t packet_type, uint16_t program_number, uint8_t stream_type, uint8_t *buf);
};

} // PTxD
} // PTx
#endif
