/*
 *  Bridge.mm
 *  PTxD
 *
 *  Created by Ryosuke Mitachi on 11/06/09.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */
#include "debug.h"

#define __BRIDGE_IMPL__
#include "Bridge.h"

bool encodingFromString(const char *str, NSStringEncoding *encoding)
{
    bool result = false;
    if ((str != NULL) && (encoding != NULL))
    {
        if (strcmp("UTF-8", str) == 0)
        {
            *encoding = NSUTF8StringEncoding;
            result = true;
        }
        else if (strcmp("EUCJP", str) == 0)
        {
            *encoding = NSJapaneseEUCStringEncoding;
            result = true;
        }
        else if (strcmp("ASCII", str) == 0)
        {
            *encoding = NSASCIIStringEncoding;
            result = true;
        }
    }
    return result;
}

char *strdupWithReplacingPercentEscapesUsingEncoding(const char *str, const char *encoding)
{
    DebugLog3("strdupWithReplacingPercentEscapesUsingEncoding\n");
    char *result = NULL;
    if ((str != NULL) && (encoding != NULL))
    {
        DebugLog3("check 1\n");
        NSStringEncoding enc = NSUTF8StringEncoding;
        if (strcmp("UTF-8", encoding) == 0)
        {
            DebugLog3("check 2\n");
        }
        else if (strcmp("EUCJP", encoding) == 0)
        {
            DebugLog3("check 3\n");
            enc = NSJapaneseEUCStringEncoding;
        }
        DebugLog3("check 4\n");
        NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
        NSString *s = [NSString stringWithCString:str encoding:NSUTF8StringEncoding];
        if (s != nil)
        {
            DebugLog3("check 5\n");
            s = [s stringByReplacingPercentEscapesUsingEncoding:enc];
            if (s != nil)
            {
                DebugLog3("check 6\n");
                result = strdup([s cStringUsingEncoding:NSUTF8StringEncoding]);
            }
        }
        [pool release];
    }
    return result;
}

char *strdupWithFromToEncoding(const char *str, const char *fromEncoding, const char *toEncoding)
{
    char *result = NULL;
    if ((str != NULL) && (fromEncoding != NULL) && (toEncoding != NULL))
    {
        NSStringEncoding fromEnc, toEnc;
        if (encodingFromString(fromEncoding, &fromEnc) && encodingFromString(toEncoding, &toEnc))
        {
            NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
            NSString *s = [NSString stringWithCString:str encoding:fromEnc];
            if (s != nil)
            {
                result = strdup([s cStringUsingEncoding:toEnc]);
            }
            [pool release];
        }
    }
    return result;
}