# -*- coding: utf-8 -*-
"""
    Map LaTeX filenames to ReST filenames
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    :copyright: 2007-2008 by Georg Brandl.
    :license: BSD.
"""

# '' means: use same name, strip prefix if applicable.
# None means: don't translate at all.

_mapping = {
    'lib': {
        '__newname__' : 'library',

        'asttable': '',
        'compiler': '',
        'distutils': '',
        'email': '',
        'emailcharsets': 'email.charset',
        'emailencoders': 'email.encoders',
        'emailexc': 'email.errors',
        'emailgenerator': 'email.generator',
        'emailheaders': 'email.header',
        'emailiter': 'email.iterators',
        'emailmessage': 'email.message',
        'emailmimebase': 'email.mime',
        'emailparser': 'email.parser',
        'emailutil': 'email.util',
        'libaifc': '',
        'libanydbm': '',
        'libarray': '',
        'libascii': 'curses.ascii',
        'libast': '',
        'libasynchat': '',
        'libasyncore': '',
        'libatexit': '',
        'libaudioop': '',
        'libbase64': '',
        'libbasehttp': 'basehttpserver',
        'libbastion': '',
        'libbinascii': '',
        'libbinhex': '',
        'libbisect': '',
        'libbltin': '__builtin__',
        'libbsddb': '',
        'libbz2': '',
        'libcalendar': '',
        'libcfgparser': 'configparser',
        'libcgihttp': 'cgihttpserver',
        'libcgi': '',
        'libcgitb': '',
        'libchunk': '',
        'libcmath': '',
        'libcmd': '',
        'libcodecs': '',
        'libcodeop': '',
        'libcode': '',
        'libcollections': '',
        'libcolorsys': '',
        'libcommands': '',
        'libcompileall': '',
        'libcontextlib': '',
        'libcookielib': '',
        'libcookie': '',
        'libcopyreg': 'copy_reg',
        'libcopy': '',
        'libcrypt': '',
        'libcsv': '',
        'libctypes': '',
        'libcursespanel': 'curses.panel',
        'libcurses': '',
        'libdatetime': '',
        'libdbhash': '',
        'libdbm': '',
        'libdecimal': '',
        'libdifflib': '',
        'libdircache': '',
        'libdis': '',
        'libdl': '',
        'libdoctest': '',
        'libdocxmlrpc': 'docxmlrpcserver',
        'libdumbdbm': '',
        'libdummythreading': 'dummy_threading',
        'libdummythread': 'dummy_thread',
        'liberrno': '',
        'libetree': 'xml.etree.elementtree',
        'libfcntl': '',
        'libfilecmp': '',
        'libfileinput': '',
        'libfnmatch': '',
        'libformatter': '',
        'libfpectl': '',
        'libfpformat': '',
        'libftplib': '',
        'libfunctools': '',
        'libfuture': '__future__',
        'libgc': '',
        'libgdbm': '',
        'libgetopt': '',
        'libgetpass': '',
        'libgettext': '',
        'libglob': '',
        'libgrp': '',
        'libgzip': '',
        'libhashlib': '',
        'libheapq': '',
        'libhmac': '',
        'libhotshot': '',
        'libhtmllib': '',
        'libhtmlparser': '',
        'libhttplib': '',
        'libimageop': '',
        'libimaplib': '',
        'libimgfile': '',
        'libimghdr': '',
        'libimp': '',
        'libinspect': '',
        'libitertools': '',
        'libjpeg': '',
        'libkeyword': '',
        'liblinecache': '',
        'liblocale': '',
        'liblogging': '',
        'libmailbox': '',
        'libmailcap': '',
        'libmain': '__main__',
        'libmarshal': '',
        'libmath': '',
        'libmd5': '',
        'libmhlib': '',
        'libmimetools': '',
        'libmimetypes': '',
        'libmimewriter': '',
        'libmimify': '',
        'libmmap': '',
        'libmodulefinder': '',
        'libmsilib': '',
        'libmsvcrt': '',
        'libmultifile': '',
        'libmutex': '',
        'libnetrc': '',
        'libnew': '',
        'libnis': '',
        'libnntplib': '',
        'liboperator': '',
        'liboptparse': '',
        'libos': '',
        'libossaudiodev': '',
        'libparser': '',
        'libpdb': '',
        'libpickle': '',
        'libpickletools': '',
        'libpipes': '',
        'libpkgutil': '',
        'libplatform': '',
        'libpopen2': '',
        'libpoplib': '',
        'libposixpath': 'os.path',
        'libposix': '',
        'libpprint': '',
        'libprofile': '',
        'libpty': '',
        'libpwd': '',
        'libpyclbr': '',
        'libpycompile': 'py_compile',
        'libpydoc': '',
        'libpyexpat': '',
        'libqueue': '',
        'libquopri': '',
        'librandom': '',
        'libreadline': '',
        'librepr': '',
        'libre': '',
        'libresource': '',
        'librexec': '',
        'librfc822': '',
        'librlcompleter': '',
        'librobotparser': '',
        'librunpy': '',
        'libsched': '',
        'libselect': '',
        'libsets': '',
        'libsgmllib': '',
        'libsha': '',
        'libshelve': '',
        'libshlex': '',
        'libshutil': '',
        'libsignal': '',
        'libsimplehttp': 'simplehttpserver',
        'libsimplexmlrpc': 'simplexmlrpcserver',
        'libsite': '',
        'libsmtpd': '',
        'libsmtplib': '',
        'libsndhdr': '',
        'libsocket': '',
        'libsocksvr': 'socketserver',
        'libspwd': '',
        'libsqlite3': '',
        'libstat': '',
        'libstatvfs': '',
        'libstringio': '',
        'libstringprep': '',
        'libstring': '',
        'libstruct': '',
        'libsunaudio': '',
        'libsunau': '',
        'libsubprocess': '',
        'libsymbol': '',
        'libsyslog': '',
        'libsys': '',
        'libtabnanny': '',
        'libtarfile': '',
        'libtelnetlib': '',
        'libtempfile': '',
        'libtermios': '',
        'libtest': '',
        'libtextwrap': '',
        'libthreading': '',
        'libthread': '',
        'libtimeit': '',
        'libtime': '',
        'libtokenize': '',
        'libtoken': '',
        'libtraceback': '',
        'libtrace': '',
        'libtty': '',
        'libturtle': '',
        'libtypes': '',
        'libunicodedata': '',
        'libunittest': '',
        'liburllib2': '',
        'liburllib': '',
        'liburlparse': '',
        'libuserdict': '',
        'libuser': '',
        'libuuid': '',
        'libuu': '',
        'libwarnings': '',
        'libwave': '',
        'libweakref': '',
        'libwebbrowser': '',
        'libwhichdb': '',
        'libwinreg': '_winreg',
        'libwinsound': '',
        'libwsgiref': '',
        'libxdrlib': '',
        'libxmllib': '',
        'libxmlrpclib': '',
        'libzipfile': '',
        'libzipimport': '',
        'libzlib': '',
        'tkinter': '',
        'xmldomminidom': 'xml.dom.minidom',
        'xmldompulldom': 'xml.dom.pulldom',
        'xmldom': 'xml.dom',
        'xmletree': 'xml.etree',
        'xmlsaxhandler': 'xml.sax.handler',
        'xmlsaxreader': 'xml.sax.reader',
        'xmlsax': 'xml.sax',
        'xmlsaxutils': 'xml.sax.utils',
        'libal': '',
        'libcd': '',
        'libfl': '',
        'libfm': '',
        'libgl': '',
        'libposixfile': '',

        # specials
        'libundoc': '',
        'libintro': '',

        'libconsts': 'constants',
        'libexcs': 'exceptions',
        'libfuncs': 'functions',
        'libobjs': 'objects',
        'libstdtypes': 'stdtypes',

        # mainfiles
        'lib': None,
        'mimelib': None,

        # obsolete
        'libni': None,
        'libcmpcache': None,
        'libcmp': None,

        # chapter overviews
        'fileformats': '',
        'filesys': '',
        'frameworks': '',
        'i18n': '',
        'internet': '',
        'ipc': '',
        'language': '',
        'archiving': '',
        'custominterp': '',
        'datatypes': '',
        'development': '',
        'markup': '',
        'modules': '',
        'netdata': '',
        'numeric': '',
        'persistence': '',
        'windows': '',
        'libsun': '',
        'libmm': '',
        'liballos': '',
        'libcrypto': '',
        'libsomeos': '',
        'libsgi': '',
        'libmisc': '',
        'libpython': '',
        'librestricted': '',
        'libstrings': '',
        'libunix': '',

        # japanese translation info.
        'jptranslation': '',
    },

    'ref': {
        '__newname__': 'reference',
        'ref': None,
        'ref1': 'introduction',
        'ref2': 'lexical_analysis',
        'ref3': 'datamodel',
        'ref4': 'executionmodel',
        'ref5': 'expressions',
        'ref6': 'simple_stmts',
        'ref7': 'compound_stmts',
        'ref8': 'toplevel_components',
        # japanese translation info.
        'jptranslation': '',
    },

    'tut': {
        '__newname__': 'tutorial',
        '__labelprefix__': 'tut-',
        'tut': 'tutorial:split',
        'glossary': 'glossary',
        # japanese translation info.
        'jptranslation': '',
    },

    'api': {
        '__newname__': 'c-api',
        '__defaulthighlightlang__': 'c',
        'api': None,

        'abstract': '',
        'concrete': '',
        'exceptions': '',
        'init': '',
        'intro': '',
        'memory': '',
        'newtypes': '',
        'refcounting': '',
        'utilities': '',
        'veryhigh': '',
        # japanese translation info.
        'jptranslation': '',
    },

    'ext': {
        '__newname__': 'extending',
        '__defaulthighlightlang__': 'c',
        'ext': None,

        'building': '',
        'embedding': '',
        'extending': 'extending',
        'newtypes': '',
        'windows': '',
        # japanese translation info.
        'jptranslation': '',
    },

    'dist': {
        '__newname__': 'distutils',
        'dist': 'distutils:split',
        'sysconfig': '',
        # japanese translation info.
        'jptranslation': '',
    },

    'mac': {
        '__newname__': 'maclib',
        'mac': None,

        'libaepack': 'aepack',
        'libaetools': 'aetools',
        'libaetypes': 'aetypes',
        'libautogil': 'autogil',
        'libcolorpicker': 'colorpicker',
        'libframework': 'framework',
        'libgensuitemodule': 'gensuitemodule',
        'libmacic': 'macic',
        'libmacos': 'macos',
        'libmacostools': 'macostools',
        'libmac': 'mac',
        'libmacui': 'macui',
        'libminiae': 'miniae',
        'libscrap': 'scrap',
        'scripting': '',
        'toolbox': '',
        'undoc': '',
        'using': '',
        # japanese translation info.
        'jptranslation': '',
    },

    'inst': {
        '__newname__': 'install',
        '__defaulthighlightlang__': 'none',
        'inst': 'index',
        # japanese translation info.
        'jptranslation': '',
    },

    'whatsnew': {
        '__newname__': 'whatsnew',
        'whatsnew20': '2.0',
        'whatsnew21': '2.1',
        'whatsnew22': '2.2',
        'whatsnew23': '2.3',
        'whatsnew24': '2.4',
        'whatsnew25': '2.5',
        'whatsnew26': '2.6',
        'whatsnew30': '3.0',
        # japanese translation info.
        'jptranslation': '',
    },

    'commontex': {
        '__newname__': '',
        'boilerplate': None,
        'patchlevel': None,
        'copyright': "",
        'license': '',
        'reportingbugs': 'bugs',
        # japanese translation info.
        'boilerplatejp': None,
        'copyrightjp': '',
    },
}

fn_mapping = {}

for dir, files in _mapping.iteritems():
    newmap = fn_mapping[dir] = {}
    for fn in files:
        if not fn.startswith('_') and files[fn] == '':
            if fn.startswith(dir):
                newmap[fn] = fn[len(dir):]
            else:
                newmap[fn] = fn
        else:
            newmap[fn] = files[fn]


# new directories to create
dirs_to_make = [
    'c-api',
    'data',
    'distutils',
    'documenting',
    'extending',
    'includes',
    'includes/sqlite3',
    'install',
    'maclib',
    'library',
    'reference',
    'tutorial',
    'whatsnew',
    'tools',
]

# includefiles for \verbatiminput and \input
includes_mapping = {
    '../../Parser/Python.asdl': None,     # XXX
    '../../Lib/test/exception_hierarchy.txt': None,
    'emailmessage': 'email.message.rst',
    'emailparser': 'email.parser.rst',
    'emailgenerator': 'email.generator.rst',
    'emailmimebase': 'email.mime.rst',
    'emailheaders': 'email.header.rst',
    'emailcharsets': 'email.charset.rst',
    'emailencoders': 'email.encoders.rst',
    'emailexc': 'email.errors.rst',
    'emailutil': 'email.util.rst',
    'emailiter': 'email.iterators.rst',
}

# new files to copy from converter/newfiles
newfiles_mapping = {
    'conf.py': 'conf.py',
    'TODO': 'TODO',
    'ACKS': 'ACKS',

    'ref_index.rst': 'reference/index.rst',
    'tutorial_index.rst': 'tutorial/index.rst',
    'modules_index.rst': 'library/index.rst',
    'mac_index.rst': 'maclib/index.rst',
    'ext_index.rst': 'extending/index.rst',
    'api_index.rst': 'c-api/index.rst',
    'dist_index.rst': 'distutils/index.rst',
    'contents.rst': 'contents.rst',
    'about.rst': 'about.rst',

    'doc.rst': 'documenting/index.rst',
    'doc_intro.rst': 'documenting/intro.rst',
    'doc_style.rst': 'documenting/style.rst',
    'doc_sphinx.rst': 'documenting/sphinx.rst',
    'doc_rest.rst': 'documenting/rest.rst',
    'doc_markup.rst': 'documenting/markup.rst',
}

# copy files from the old doc tree
copyfiles_mapping = {
    'api/refcounts.dat': 'data',
    'lib/email-*.py': 'includes',
    'lib/minidom-example.py': 'includes',
    'lib/tzinfo-examples.py': 'includes',
    'lib/sqlite3/*.py': 'includes/sqlite3',
    'ext/*.c': 'includes',
    'ext/*.py': 'includes',
    'commontex/typestruct.h': 'includes',
}

# files to rename
rename_mapping = {
    'tutorial/1_tutorial.rst': None, # delete
    'tutorial/2_tutorial.rst': 'tutorial/appetite.rst',
    'tutorial/3_tutorial.rst': 'tutorial/interpreter.rst',
    'tutorial/4_tutorial.rst': 'tutorial/introduction.rst',
    'tutorial/5_tutorial.rst': 'tutorial/controlflow.rst',
    'tutorial/6_tutorial.rst': 'tutorial/datastructures.rst',
    'tutorial/7_tutorial.rst': 'tutorial/modules.rst',
    'tutorial/8_tutorial.rst': 'tutorial/inputoutput.rst',
    'tutorial/9_tutorial.rst': 'tutorial/errors.rst',
    'tutorial/10_tutorial.rst': 'tutorial/classes.rst',
    'tutorial/11_tutorial.rst': 'tutorial/stdlib.rst',
    'tutorial/12_tutorial.rst': 'tutorial/stdlib2.rst',
    'tutorial/13_tutorial.rst': 'tutorial/whatnow.rst',
    'tutorial/14_tutorial.rst': 'tutorial/interactive.rst',
    'tutorial/15_tutorial.rst': 'tutorial/floatingpoint.rst',
    'tutorial/16_tutorial.rst': None, # delete

    'distutils/1_distutils.rst': 'distutils/introduction.rst',
    'distutils/2_distutils.rst': 'distutils/setupscript.rst',
    'distutils/3_distutils.rst': 'distutils/configfile.rst',
    'distutils/4_distutils.rst': 'distutils/sourcedist.rst',
    'distutils/5_distutils.rst': 'distutils/builtdist.rst',
    'distutils/6_distutils.rst': 'distutils/packageindex.rst',
    'distutils/7_distutils.rst': 'distutils/uploading.rst',
    'distutils/8_distutils.rst': 'distutils/examples.rst',
    'distutils/9_distutils.rst': 'distutils/extending.rst',
    'distutils/10_distutils.rst': 'distutils/commandref.rst',
    'distutils/11_distutils.rst': 'distutils/apiref.rst',
}

# toctree entries
toctree_mapping = {
    'mac/scripting': ['gensuitemodule', 'aetools', 'aepack', 'aetypes', 'miniae'],
    'mac/toolbox': ['colorpicker'],
    'mac/undoc': [],
    'lib/libstrings': ['string', 're', 'struct', 'difflib', 'stringio', 'textwrap',
                       'codecs', 'unicodedata', 'stringprep', 'fpformat'],
    'lib/datatypes': ['datetime', 'calendar', 'collections', 'heapq', 'bisect',
                      'array', 'sets', 'sched', 'mutex', 'queue', 'weakref',
                      'userdict', 'types', 'new', 'copy', 'pprint', 'repr'],
    'lib/numeric': ['math', 'cmath', 'decimal', 'random', 'itertools', 'functools',
                    'operator'],
    'lib/netdata': ['email', 'mailcap', 'mailbox', 'mhlib', 'mimetools', 'mimetypes',
                    'mimewriter', 'mimify', 'multifile', 'rfc822',
                    'base64', 'binhex', 'binascii', 'quopri', 'uu'],
    'lib/markup': ['htmlparser', 'sgmllib', 'htmllib', 'pyexpat', 'xml.dom',
                   'xml.dom.minidom', 'xml.dom.pulldom', 'xml.sax', 'xml.sax.handler',
                   'xml.sax.utils', 'xml.sax.reader', 'xml.etree.elementtree'],
    'lib/fileformats': ['csv', 'configparser', 'robotparser', 'netrc', 'xdrlib'],
    'lib/libcrypto': ['hashlib', 'hmac', 'md5', 'sha'],
    'lib/filesys': ['os.path', 'fileinput', 'stat', 'statvfs', 'filecmp',
                    'tempfile', 'glob', 'fnmatch', 'linecache', 'shutil', 'dircache'],
    'lib/archiving': ['zlib', 'gzip', 'bz2', 'zipfile', 'tarfile'],
    'lib/persistence': ['pickle', 'copy_reg', 'shelve', 'marshal', 'anydbm',
                        'whichdb', 'dbm', 'gdbm', 'dbhash', 'bsddb', 'dumbdbm',
                        'sqlite3'],
    'lib/liballos': ['os', 'time', 'optparse', 'getopt', 'logging', 'getpass',
                     'curses', 'curses.ascii', 'curses.panel', 'platform',
                     'errno', 'ctypes'],
    'lib/libsomeos': ['select', 'thread', 'threading', 'dummy_thread', 'dummy_threading',
                      'mmap', 'readline', 'rlcompleter'],
    'lib/libunix': ['posix', 'pwd', 'spwd', 'grp', 'crypt', 'dl', 'termios', 'tty',
                    'pty', 'fcntl', 'pipes', 'posixfile', 'resource', 'nis',
                    'syslog', 'commands'],
    'lib/ipc': ['subprocess', 'socket', 'signal', 'popen2', 'asyncore', 'asynchat'],
    'lib/internet': ['webbrowser', 'cgi', 'cgitb', 'wsgiref', 'urllib', 'urllib2',
                     'httplib', 'ftplib', 'poplib', 'imaplib',
                     'nntplib', 'smtplib', 'smtpd', 'telnetlib', 'uuid', 'urlparse',
                     'socketserver', 'basehttpserver', 'simplehttpserver',
                     'cgihttpserver', 'cookielib', 'cookie', 'xmlrpclib',
                     'simplexmlrpcserver', 'docxmlrpcserver'],
    'lib/libmm': ['audioop', 'imageop', 'aifc', 'sunau', 'wave', 'chunk',
                  'colorsys', 'imghdr', 'sndhdr', 'ossaudiodev'],
    'lib/i18n': ['gettext', 'locale'],
    'lib/frameworks': ['cmd', 'shlex'],
    'lib/development': ['pydoc', 'doctest', 'unittest', 'test'],
    'lib/libpython': ['sys', '__builtin__', '__main__', 'warnings', 'contextlib',
                      'atexit', 'traceback', '__future__', 'gc', 'inspect',
                      'site', 'user', 'fpectl'],
    'lib/custominterp': ['code', 'codeop'],
    'lib/librestricted': ['rexec', 'bastion'],
    'lib/modules': ['imp', 'zipimport', 'pkgutil', 'modulefinder', 'runpy'],
    'lib/language': ['parser', 'symbol', 'token', 'keyword', 'tokenize',
                     'tabnanny', 'pyclbr', 'py_compile', 'compileall', 'dis',
                     'pickletools', 'distutils'],
    'lib/compiler': ['ast'],
    'lib/libmisc': ['formatter'],
    'lib/libsgi': ['al', 'cd', 'fl', 'fm', 'gl', 'imgfile', 'jpeg'],
    'lib/libsun': ['sunaudio'],
    'lib/windows': ['msilib', 'msvcrt', '_winreg', 'winsound'],
    'lib/tkinter': [],
}

# map sourcefilename to [pre, post]
amendments_mapping = {
    'license.rst': ['''\
.. highlightlang:: none

*******************
History and License
*******************

''', ''],

    'bugs.rst': ['''\
**************
Reporting Bugs
**************

''', ''],

    'copyright.rst': ['''\
*********
Copyright
*********

''', ''],

    'install/index.rst': ['''\
.. _install-index:

''', ''],
}
