//---------------------------------------------------------------------------
//  Hadamard gate
//---------------------------------------------------------------------------
#include <cmath>
#include "QC_hadamard.h"
//---------------------------------------------------------------------------
/**
 *  Constructor
 */
QC_hadamard::QC_hadamard(int _Target) : QCalcUnit() {
    Target = _Target;
}
//---------------------------------------------------------------------------
/**
 *  Calculate
 */
void QC_hadamard::calc(int target, double R[], double I[], int NumberOfBits) {

    unsigned int state = 1<< (NumberOfBits - 1);
    const double sq2 = 1.0 / std::sqrt(2.0);

    double r0,r1,i0,i1;
    for (unsigned int i=0;i<state;i++) {
        unsigned int ix0 = insert0(i,target);
        unsigned int ix1 = insert1(i,target);

        //Hadamard
        r0 = R[ix0];
        i0 = I[ix0];
        r1 = R[ix1];
        i1 = I[ix1];

        R[ix0] = sq2*(r1+r0);
        I[ix0] = sq2*(i1+i0);

        R[ix1] = sq2*(-r1+r0);
        I[ix1] = sq2*(-i1+i0);
    }
}
//---------------------------------------------------------------------------
void
QC_hadamard::Calc(QBits *qBits) {
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part

    QC_hadamard::calc(Target, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_hadamard::calcmpi(int t1, double R[], double I[], int N) {
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;
    const double sq2 = 1.0 / std::sqrt(2.0);

    for (int i = 0; i < (1 << (N - 1)); i++) {
        // Obtain indices of state:
        ix0 = QCalcUnit::insert0(i, t1);
        ix1 = QCalcUnit::insert1(i, t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);
        if (bstore) {
            double nr0 = sq2*(r1+r0);
            double ni0 = sq2*(i1+i0);
            double nr1 = sq2*(-r1+r0);
            double ni1 = sq2*(-i1+i0);
            // Store:
            store(R, I, ix0, ix1, nr0, ni0, nr1, ni1);
        }
    }
}
#endif
//---------------------------------------------------------------------------

