//---------------------------------------------------------------------------
// Pauli Z gate
//---------------------------------------------------------------------------
#include "QC_pauliZ.h"
//---------------------------------------------------------------------------
/**
 *  Constructor
 */
QC_pauliZ::QC_pauliZ(int _Target) : QCalcUnit() {
    Target = _Target;
}
//---------------------------------------------------------------------------
/**
 *  Calculate
 */
void
QC_pauliZ::calc(int target, double R[], double I[], int NumberOfBits) {

    unsigned int state = 1<< (NumberOfBits - 1);
    for (unsigned int i=0;i<state;i++) {
        unsigned int ix1 = insert1(i,target);

        //Pauli Z

        R[ix1] = -R[ix1];
        I[ix1] = -I[ix1];
    }
}
//---------------------------------------------------------------------------
void
QC_pauliZ::Calc(QBits *qBits) {
    int N = qBits->GetNumberOfQBits();
    double *R = qBits->GetBitsR();//Real Part
    double *I = qBits->GetBitsI();//Imaginary Part

    QC_pauliZ::calc(Target, R, I, N);
}
//---------------------------------------------------------------------------
#ifdef __USE__MPI
void
QC_pauliZ::calcmpi(int t1, double R[], double I[], int N) {
    double r0 = 0.0;
    double i0 = 0.0;
    double r1 = 0.0;
    double i1 = 0.0;
    unsigned int ix0, ix1;

    for (int i = 0; i < (1 << (N - 1)); i++) {
        // Obtain indices of state:
        ix0 = QCalcUnit::insert0(i, t1);
        ix1 = QCalcUnit::insert1(i, t1);

        bool bstore = setup(R, I, ix0, ix1, r0, i0, r1, i1);
        if (bstore) {
            double nr0 = r0;
            double ni0 = i0;
            double nr1 = -r1;
            double ni1 = -i1;
            // Store:
            store(R, I, ix0, ix1, nr0, ni0, nr1, ni1);
        }
    }
}
#endif
//---------------------------------------------------------------------------

