//---------------------------------------------------------------------------
// Management Class of QCalcUnit
//---------------------------------------------------------------------------
#include <iostream>
#include <vector>

#include "QCalcManager.h"
#include "QCompilerCntl.h"
#include "QCalcUnit.h"
#include "QBits.h"
//---------------------------------------------------------------------------
/**
 * Constructor
 */
QCalcManager::QCalcManager(void) {
  mNumberOfQBits  = 0;
  mQCalcUnits.clear();
}
//---------------------------------------------------------------------------
/**
 * Constructor
 */
QCalcManager::QCalcManager(std::istream &is){
  mNumberOfQBits  = 0;
  mQCalcUnits.clear();
  AddFromIntermediate(is);
}
//---------------------------------------------------------------------------
/**
 * Destructor
 */
QCalcManager::~QCalcManager(){
  DeleteAll();
}
//---------------------------------------------------------------------------
// Interfaces
//---------------------------------------------------------------------------
/**
 *  Compile intermediate
 */
bool
QCalcManager::AddFromIntermediate(std::istream &is) {
  QCompilerCntl qccntl(is);
  QCalcUnit *cu;
  DeleteAll();
  if (true == qccntl.Compile()) {
    unsigned int cntl_size = qccntl.GetNumberOfControl();
    for (unsigned int i = 0; i < cntl_size; i++) {
      cu = qccntl.AllocateControl(i);
      if (NULL != cu) mQCalcUnits.push_back(cu);
    }
    mNumberOfQBits = qccntl.GetNumberOfQBits();
    return true;
  }else{
    return false;
  }
}
//---------------------------------------------------------------------------
/**
 *  Calculate
 */
void
QCalcManager::Calc(QBits * const qBits) {
  if (qBits->GetNumberOfQBits() >= mNumberOfQBits) {
    int unit_count = mQCalcUnits.size();
    for (int i = 0; i < unit_count; i++) {
      mQCalcUnits[i]->Calc(qBits);
    }
  } else {
    //TODO: Error
  }
}
//---------------------------------------------------------------------------
/**
 *  AddUnit
 */
void
QCalcManager::AddUnit(QCalcUnit *qc) {
  if (qc) {
    mQCalcUnits.push_back(qc);
  }
}
//---------------------------------------------------------------------------
/**
 *  Delete units
 */
void
QCalcManager::DeleteAll(void) {
  mNumberOfQBits  = 0;
  int vec_size = mQCalcUnits.size();
  for (int i = 0; i < vec_size; i++) {
    delete mQCalcUnits[i];
  }
  mQCalcUnits.clear();
}
//---------------------------------------------------------------------------
