//---------------------------------------------------------------------------
// Bit Information
//---------------------------------------------------------------------------
#include <stdlib.h>
#include "QBitbox.h"
//---------------------------------------------------------------------------
QBitbox::QBitbox(int index) :QCircuit(0,index) {
  Name = GetTypeStr();
  Text = "|0>";
  Index = index;
  Enabled = true;
  state = BIT_DOWN;
}
//---------------------------------------------------------------------------
QBitbox::QBitbox(int x, int y, string Param) :QCircuit(0,y) {
  Name = GetTypeStr();
  Text = "|0>";
  Index = y;
  Enabled = true;
  state = BIT_DOWN;
  SetState(atoi(Param.c_str()));
}
//---------------------------------------------------------------------------
void
QBitbox::Draw(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = d;
  int y1 = Index * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetBrushColor(clWhite);
  qDraw->FillRect(x1,y1,x2,y2);

  if (!Enabled) {
    qDraw->SetBrushColor(clRed);
  } else {
    qDraw->SetBrushColor(clBlack);
  }

  qDraw->FrameRect(x1,y1,x2,y2);

  qDraw->SetBrushColor(clWhite);
  ostringstream os;
  os << "|" << state << ">";
  qDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,os.str());
}
//---------------------------------------------------------------------------
string
QBitbox::GetCalcText(void) {
  if (state == BIT_DOWN) {
    return "blank";
  }
  ostringstream os;
  os << "NOT(q[" << Y << "])";
  return os.str();
}
//---------------------------------------------------------------------------
void
QBitbox::DrawPS(QPSDraw *psDraw) {

  if (!Enabled)
    return;
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = d;
  int y1 = Index * GridSize+d;

  psDraw->FillRect(GridSize*X,GridSize*Y,GridSize*X+GridSize,GridSize*Y+GridSize);
  psDraw->TextOut(x1+UnitSize/2,y1+UnitSize/2,Text.c_str());
}
//---------------------------------------------------------------------------
string
QBitbox::GetParam(void) {
  ostringstream os;
  os << state;
  return os.str();
}
//---------------------------------------------------------------------------
void
QBitbox::Reverse(int y) {
  Index = y - Index;
  Y = y - Y;
}
//---------------------------------------------------------------------------
TRect
QBitbox::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//---------------------------------------------------------------------------
void
QBitbox::SetState(int st) {
  state = st;
  if (state == BIT_DOWN) {
    Text = "|0>";
  } else {
    Text = "|1>";
  }
}
//---------------------------------------------------------------------------
int
QBitbox::GetState() {
  return state;
}
//---------------------------------------------------------------------------
QCircuit*
QBitbox::Clone() {
  QBitbox *qb = new QBitbox(Index);
  qb->SetState(GetState());
  qb->Enabled = Enabled;
  return (QCircuit*)qb;
}
//---------------------------------------------------------------------------

