//---------------------------------------------------------------------------
// Bit Information
//---------------------------------------------------------------------------
#ifndef QBitboxH
#define QBitboxH
#include "QCircuit.h"

const int BIT_DOWN = 0;
const int BIT_UP   = 1;
//---------------------------------------------------------------------------
class QBitbox : public QCircuit {
private:
  int Index;
  int state;
  string Text;

public:
  QBitbox(int index);
  QBitbox(int x, int y, string Param);


  bool Enabled;

  virtual int        GetType(void)    { return QC_BITBOX; }
  virtual string GetTypeStr(void) { return "QBitBox"; }

  void Draw(QDraw *Draw);
  string GetCalcText(void);
  virtual void Calc(QBits *qBits) {}
  void DrawPS(QPSDraw *psDraw);
  string GetParam(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  void SetState(int st);
  int GetState();
  QCircuit *Clone();
};
//---------------------------------------------------------------------------
#endif
