//---------------------------------------------------------------------------
#ifndef QCCnotH
#define QCCnotH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QCCNot : public QCircuit {
private:

  int Target1;
  int Target2;

public:
  QCCNot(int x,int y);
  QCCNot(int x,int y, string Param);

  virtual int        GetType(void)    { return QC_CCNOT; }
  virtual string GetTypeStr(void) { return "QCCNot"; }

  string GetCalcText(void);

  void SetTarget1(int t) {Target1=t;};
  void SetTarget2(int t) {Target2=t;};
  int GetTarget1(void) {return Target1;};
  int GetTarget2(void) {return Target2;};


  void Draw(QDraw *Draw);
  void DrawPS(QPSDraw *psDraw);
  string GetParam(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone();

};
//---------------------------------------------------------------------------
#endif
