//---------------------------------------------------------------------------
#ifndef QCRotH
#define QCRotH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QCRot : public QCircuit {
private:

  int Target;
  double Phase;

public:
  QCRot(int x,int y);
  QCRot(int x,int y, string Param);

  virtual int        GetType(void)    { return QC_CROT; }
  virtual string GetTypeStr(void) { return "QCRot"; }

  string GetCalcText(void);

  void SetTarget(int t) {Target=t;};
  int GetTarget(void) {return Target;};

  void Draw(QDraw *Draw);
  void DrawPS(QPSDraw *psDraw);
  string GetParam(void);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone();

  double GetPhase(void){
    return Phase;
  };
  void SetPhase(double p){
    Phase = p;
  };
};
#endif
