//---------------------------------------------------------------------------
#ifndef QCnotH
#define QCnotH
//---------------------------------------------------------------------------
#include "QCircuit.h"
//---------------------------------------------------------------------------
class QCNot : public QCircuit {
private:

  int Target;

public:
  QCNot(int x,int y);
  QCNot(int x,int y, string Param);


  virtual int        GetType(void)    { return QC_CNOT; }
  virtual string GetTypeStr(void) { return "QCNot"; }

  string GetCalcText(void);

  void SetTarget(int t) {Target=t;};
  int GetTarget(void) {return Target;};

  void Draw(QDraw *Draw);
  void DrawPS(QPSDraw *psDraw);
  void Reverse(int y);
  TRect GetOccupiedRect();
  QCircuit *Clone();
  string GetParam(void);

};
//---------------------------------------------------------------------------
#endif
