//---------------------------------------------------------------------------
#include <sstream>
#include "QMeasure.h"
//---------------------------------------------------------------------------
QMeasure::QMeasure(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
}
//---------------------------------------------------------------------------
void
QMeasure::Draw(QDraw *qDraw) {
  qDraw->DrawMeasure(X,Y);
}
//---------------------------------------------------------------------------
void QMeasure::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();
  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Y * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->FillRect(x1,y1,x2+d*2,y2);
  psDraw->FrameRect(x1,y1,x2,y2);
  psDraw->DrawMeasure(X*GridSize + UnitSize/2+d,Y*GridSize+d+UnitSize/4);
}
//---------------------------------------------------------------------------
void QMeasure::Reverse(int y) {
  Y = y-Y;
}
//---------------------------------------------------------------------------
string
QMeasure::GetCalcText(void) {
  ostringstream os;
  os << "MEASURE(q[" << Y << "])";
  return os.str();
}
//---------------------------------------------------------------------------
TRect
QMeasure::GetOccupiedRect() {
  return TRect(X, Y, X + 1, Y + 1);
}
//---------------------------------------------------------------------------

