//---------------------------------------------------------------------------
#include "QSwap.h"
#include "StrUtils.h"
//---------------------------------------------------------------------------
QSwap::QSwap(int x,int y) :QCircuit(x,y) {
  Name = GetTypeStr();
  Target1 = Y;
  Target2 = Y;
}
//---------------------------------------------------------------------------
QSwap::QSwap(int x,int y, string param) :QCircuit(x,y) {
  Name = GetTypeStr();
  Target1 = Y;
  Target2 = Y;
  vector<string> v = StrUtils::split_str(param);
  Target1 = atoi(v[0].c_str());
  Target2 = atoi(v[1].c_str());
}
//---------------------------------------------------------------------------
void QSwap::SetTarget(int t1, int t2) {
  if (t1 < t2) {
    Target1 = t1;
    Target2 = t2;
  } else {
    Target1 = t2;
    Target2 = t1;
  }
  Y = Target1;
}
//---------------------------------------------------------------------------
void QSwap::Draw(QDraw *qDraw) {
  int GridSize = qDraw->GetGridSize();
  int UnitSize = qDraw->GetUnitSize();

  int tx = X*GridSize + GridSize/2;
  int ty1 = Target1*GridSize + GridSize/2;
  int ty2 = Target2*GridSize + GridSize/2;
  qDraw->SetPenColor(clBlack);
  qDraw->DrawLine(tx,ty1,tx,ty2);

  int d  = (GridSize - UnitSize) / 2;
  int x1 = X * GridSize+d;
  int y1 = Target1 * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  qDraw->SetPenColor(clBlack);
  qDraw->DrawLine(x1, y1, x2, y2);
  qDraw->DrawLine(x1, y2, x2, y1);

  y1 = Target2 * GridSize + d;
  y2 = y1 + UnitSize;

  qDraw->SetPenColor(clBlack);
  qDraw->DrawLine(x1, y1, x2, y2);
  qDraw->DrawLine(x1, y2, x2, y1);
}
//---------------------------------------------------------------------------
string
QSwap::GetCalcText(void) {
  ostringstream os;
  os << "SWAP(";
  os << "q[" << Target1 << "],";
  os << "q[" << Target2 << "])";
  return os.str();
}
//---------------------------------------------------------------------------
void QSwap::DrawPS(QPSDraw *psDraw) {
  int GridSize = psDraw->GetGridSize();
  int UnitSize = psDraw->GetUnitSize();

  int tx1 = X*GridSize + GridSize/2;

  int ty1 = Target1*GridSize + GridSize/2;
  int ty2 = Target2*GridSize + GridSize/2;
  psDraw->DrawLine(tx1,ty1,tx1,ty2);


  int d = (GridSize-UnitSize)/2;
  int x1 = X * GridSize+d;
  int y1 = Target1 * GridSize+d;
  int x2 = x1 + UnitSize;
  int y2 = y1 + UnitSize;

  psDraw->DrawLine(x1, y1, x2, y2);
  psDraw->DrawLine(x1, y2, x2, y1);

  y1 = Target2 * GridSize;
  y2 = y1 + UnitSize;

  psDraw->DrawLine(x1, y1, x2, y2);
  psDraw->DrawLine(x1, y2, x2, y1);
}
//---------------------------------------------------------------------------
string
QSwap::GetParam(void) {
  ostringstream os;
  os << Target1 << "," << Target2;
  return os.str();
}
//---------------------------------------------------------------------------
void QSwap::Reverse(int y) {
  Y = y - Y;
  Target1 = y - Target1;
  Target2 = y - Target2;
}
//---------------------------------------------------------------------------
TRect QSwap::GetOccupiedRect() {
  return TRect(X, Target1, X + 1, Target2 + 1);
}
//---------------------------------------------------------------------------
QCircuit *QSwap::Clone() {
  QSwap * qs = new QSwap(X, Y);
  qs->SetTarget(this->GetTarget1(), this->GetTarget2());
  return (QCircuit*)qs;
}
//---------------------------------------------------------------------------
