//----------------------------------------------------------------------------
//  Parse information
//----------------------------------------------------------------------------
#ifdef __BORLANDC__
#include <vcl.h>
#pragma hdrstop
#endif //__BORLANDC__

#include <iostream>
#include <string>
#include <vector>
#include "QParseInfo.h"

//----------------------------------------------------------------------------
#ifdef __BORLANDC__
#pragma package(smart_init)
#endif //__BORLANDC__


std::vector<int> dummy_vec;

/**
 *  Constructor
 */
QParseInfo::QParseInfo(const int _operator, const std::vector<int> &_targets,
                       const double _rotation, const bool _result,
                       const int _error) {
  mOperator       = _operator;
  mTargetIndices  = _targets;
  mRotation       = _rotation;
  mParseResult    = _result;
  mErrorNo        = _error;
}

/**
 *  Constructor for error notification
 */
QParseInfo::QParseInfo(const int _error) {
  mOperator       = -1;
  mTargetIndices  = dummy_vec;
  mRotation       = 0;
  mParseResult    = false;
  mErrorNo        = _error;
}

/**
 *  Copy constructor
 */
QParseInfo::QParseInfo(const QParseInfo &pinfo) {
  mOperator       = pinfo.mOperator;
  mTargetIndices  = pinfo.mTargetIndices;
  mRotation       = pinfo.mRotation;
  mParseResult    = pinfo.mParseResult;
  mErrorNo        = pinfo.mErrorNo;
}

/**
 *  Operator<<
 */
std::ostream &operator<<(std::ostream &os, const QParseInfo &pinfo) {
  os <<   "operator    : " << pinfo.mOperator;
  if (pinfo.mParseResult)
    os << "\nparse result: true";
  else
    os << "\nparse result: false";
  os << "\nerror no.   : " << pinfo.mErrorNo;
  return os;
}
