/*
 *  Copyright (C) 2002 QCAD project.  All Rights Reserved.
 *
 *  Questions and comments to:
 *       <mailto:jun@bopper.t.u-tokyo.ac.jp>
 *       <http://acolyte.t.u-tokyo.ac.jp/~kaityo/qcaddev/>
 */

#include <iostream>
#include <fstream>
#include <cstdlib>

#include "QBits.h"
#include "QCalcManager.h"
#include "QCompiler.h"
#include "QParseInfo.h"

int main(void) {
//std::ifstream ifs("sample1.mcd", std::ios::in);
  std::ifstream ifs("sample1.mcd", std::ios::in);
  if (!ifs) {
    std::cerr << "Cannot open the source file.\n";
    std::exit(1);
  }
  QBits *qBits = new QBits(7);
  QCalcManager *qCalcManager = new QCalcManager(ifs);

  std::cout << qBits << "\n";
  qCalcManager->Calc(qBits);
  std::cout << qBits << "\n";
  std::cout << "done." << std::endl;

  qBits->SaveToFile("sample1.qdt");

  delete qBits;
  delete qCalcManager;
  ifs.close();
}
