=begin head
<title>Qcad Help File</title>
<META http-equiv="Content-Style-Type" content="text/css">
<STYLE TYPE="text/css">
<!--
body {line-height: 120%;  background-color:#ffffd2; color: black}
A:link { text-decoration:none; font-weight:bold; color:#161FFA }
A:visited { text-decoration:none; font-weight:bold; color:#06AAFF }
A:active { text-decoration:none; font-weight:bold; color:#8470FF }
A:hover { font-weight:bold; color:#FF707F }
H1 {padding-top:10px;text-align: center}
H2 {padding-top:10px;border-top: black 1px solid;}
code {padding:10px; display:block;white-space:pre;border: solid 1px #AAAAAA;}
dt{font-weight:bold;}
div.footer{text-align:center;color:#800000;}
-->
</STYLE>
=end

=begin
=QCAD - HelpFile
((:<div align=center><img src="img/qcadico48.png"></div>:))

QCAD is a windows-based GUI environment of Quantum Computing Simulation, it will help you to study quantum computations. 

This software has following functions.

(1) Graphical Designing Environment for Quantum Circuits.
(2) Quantum Simulator
(3) Exportable EPS and Bitmap file of circuits designed by QCAD.

==Table of contents

* About:
  * ((<Specifications>))
  * ((<Installation & Uninstallation>))
* Design Circuits:
  * ((<Edit Window>))
  * ((<Circuit Panel>))
  * ((<Available Quantum Gates>))
  * ((<Save & Load>))
  * ((<Export Other Format>))
* Menu References:
  * ((<Menu References>))
* Simulator:
  * ((<Simulate Circuit>))
  * ((<Measurement>))
  * ((<Save Results>))
*Other Information:
  * ((<Known Problems>))
  * ((<About Developers>))
  * ((<License>))
  * ((<Acknowledgements>))
  * ((<History>))

==Specifications

===Functions

:GUI Environment to design quantum circuits
  QCAD enables you to design quantum circuits easily with full GUI (graphical user interface) environment. 
:Exportable EPS and BMP
  QCAD can export the designed circuits as Encapsulated PostScript (EPS) in order to include in LaTeX files. 
:Built-in Simulator
  QCAD can simulate the designed circuit and show results (states of qubits).

See ((<Available Quantum Gates>)). The matrices of the gates are also shown there.

===System Requirements

:Operating System
  Windows 2000 or higher. QCAD does not work on Linux or Mac OS.


==Installation & Uninstallation

===Installation
(1)  Unpack the archive file to any folder (e.g. c:\util\qcad).
(2)  Double click the icon of QCAD ((<"IMG:img/qcad.png">)) to execute it.

===Uninstallation

Remove installed folder and its contents.

NOTE:  QCAD will never touch any registries of your system.

==Edit Window

   When QCAD is executed, you can see "Edit Window". You can put gates on it.

:Bitbox
  The left end of it, there are "Bitbox". You can modify the initial states of qubits with it.
:Multi Select
  If you want to select many gates at the same time, click gates with the control key. 


==Circuit Panel


  Circuit Panel is a circuit selector. 

You can open it by choosing "Circuit Panel" by "View" menu.


  Click a button which shows a circuit that you want to put.

Then the circuit is selected.

Next, Click the edit window, then the circuit is put there.


  If the circuit requires parameter, the parameter window will open.

Set all parameters like as control bits, and then push OK. 






==Available Quantum Gates


* ((<"IMG:img/walsh.png">)) Walsh Hadamard Gate
* ((<"IMG:img/not.png">)) Not Gate
* ((<"IMG:img/cnot.png">)) Controlled Not Gate
* ((<"IMG:img/ccnot.png">)) Toffoli (Controlled Controlled Not) Gate
* ((<"IMG:img/rot.png">)) Rotation Gate
* ((<"IMG:img/crot.png">)) Controlled Rotation Gate
* ((<"IMG:img/x.png">)) Pauli X Gate
* ((<"IMG:img/y.png">)) Pauli Y Gate
* ((<"IMG:img/z.png">)) Pauli Z Gate
* ((<"IMG:img/swap.png">)) Swap Gate
* ((<"IMG:img/mesure2.png">)) Measurement Gate

=== Bitbox


   Gate "Bitbox" are special gates. They are irremovable. You can set the initial value of qubits.

If you want to set initial value of qubit as |0...01>, change state of Bitbox at Q1 to "1",

and "0" for other Bitbox.


   If you set Enabled to false, the line become disabled. This function is for exporting an EPS file. You can get EPS file with skipping this line.


=== Matrices for gates


((<"IMG:img/qgates.png">))

==Save & Load


   You can save and load the circuit data of QCAD by "Save" and  "Load" options on "File" menu. A default extension is "qcd".

==Export Other Format

=== Export EPS


  You can export a designed circuit as EPS(Encapsulated PostScript) file which is suitable for LaTeX or other types of document.

After designing a circuit, choose "Export EPS file".


=== Export Bitmap File


  If you need a bitmap file of a designed circuit, you can export a bitmap file which is what you see at the edit window. After designing a circuit, choose "Export as Bitmap file".

==Menu References


The Menus and their short cuts allow quick access to many operations. The Following menus are available.


((<File Menu>))

((<View Menu>))

((<Edit Menu>))

((<Calc Menu>))

((<Help Menu>))




==File Menu


The File menu allows access to the operations of saving and loading data, exporting as other formats and quitting QCAD.


=== New
((<"IMG:img/00new.png">))

Select the "New" option to obtain a new circuit. QCAD will ask you the size of it. If there is an unsaved circuits, the confirm dialog opens, asking for a file name for the designed circuit.


=== Open
((<"IMG:img/01open.png">))

Select the "Open" option to open the designed QCAD file. If there is an unsaved circuits, the confirm dialog opens, asking for a file name for the designed circuit.


=== Save
((<"IMG:img/02save.png">))

Select the "Save" option to save the designed circuit to the file.

If you have not set the name of file, Save Dialog appears and requires the filename.


=== Save As

Select the "Save As" option to save the designed circuit to the file with desired filename. Save Dialog appears and requires the filename.


=== Export as EPS file
((<"IMG:img/08saveasps.png">))

Select the "Export as EPS file" option to export the designed circuit as the EPS(Encapsulated PostScript) file format. This format is suitable for LaTeX or other document to include.

=== Export as Bitmap file
((<"IMG:img/07saveasbmp.png">))

Select the "Export as Bitmap file" option to export the designed circuit as the Bitmap file format. The current format of the bitmap is the type of 8bit(including 256 colors).

=== Print

Print the current circuit.

=== Print Setup

Setup a printer.

=== Exit

Select the "Exit" option to quit designing and close the QCAD. If there is an unsaved circuits, the confirm dialog opens, asking for a file name for the designed circuit.

==View Menu

The View menu allows access to Circuit Panel.

=== Circuit Panel

Select the Circuit Panel option to open the circuit panel. See <a href="#HLP000011">Circuit Panel</a> section for more information.

==Edit Menu


Edit menu allows to the operations which modify the designing circuit.


=== Undo
((<"IMG:img/03undo.png">))

Select the Undo option to undo the previous operations. You can undo all operations and the number of undo is unlimited (it depends on the size of memory of your system).

=== Remove
((<"IMG:img/04remove.png">))

Select the Remove option to remove the selected gates.

==Calc Menu

Edit menu allows to operations to the simulator of the QCAD.

See ((<Simulate Circuit>)) section for details.

==Help Menu

The Help menu allows access to the help or version information of the QCAD.

=== Help
((<"IMG:img/05help.png">))

Select the Help option to open the contents of QCAD help file.

=== Version

Select the Version option to show the version information of the QCAD.

==Simulate Circuit
((<"IMG:img/06run.png">))

   You can simulate a designed circuit on QCAD.

Try "Calc" of "Calc" menu, or hit "F5" key, and QCAD simulate your circuits and show results.

WARNING:

The calculation of the quantum circuits requires huge memory. When the circuit has 32 lines, for example, it will use 64GB. If you try to calculate large circuits, your machine might be in trouble.

==Measurement

  From Ver. 1.92, measurement gates has been available. If a circuit contains measurement gates, the "Measurement View" becomes available.

((<"IMG:img/measurement3.png">)) 

For example, the above circuits involves the following measured result.

((<"IMG:img/measurement4.png">)) 

The result contains indeces, qubits' status, and the probability that the status to be measured, respectively.

=== NOTE:

This measurememt DOES NOT achieve real measurement.
The measurement gates on QCAD do only set "measurement flags". After the calculation, the measurement is performed.

For example, the following two circuits are equivalent on QCAD.

((<"IMG:img/measurement1.png">))
((<"IMG:img/measurement2.png">))

==Save Results

:Save Results
  You can save the simulated results as a text file (Comma Separated Values).

The format of the exported file is as follows,

 #QCAD Result file
 #ex) Index), (Qubits conf.), (Abs. value), (Re. part), (Im. part)
 #ex)      0, |00000>       , 1.000       , 0.4455    , 0.23  
 0,|0000000>, 1.000000,1.000000,0.000000
 1,|0000001>, 0.000000,0.000000,0.000000
 .....
 127,|1111111>, 0.000000,0.000000,0.000000

:Save Measured Results
  If you want to save the measured results, select the "Save Results" menu on the "File" menu after choosing "Measurement view". The format of the results file is equivalent to which showed on Measurement view.

==Known Problems

QCAD has some problems as following.

(1) Step-by-step execution is not available yet.

==About Developers

* Hiroshi Watanabe (Representative)
* Masaru Suzuki (Programmer)
* Junnosuke Yamazaki (Programmer) 

==License

Copyright (C) 2002 - 2011 QCAD Developers Team

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

(1) In any scientific publication based wholly or in part on the Software, the use of the Software must be acknowledged.
(2) Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
(3) Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 

 THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL  OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==Acknowledgements

This work is supported by a grant under the youth section of Exploratory Software
Project FY2002 (IPA, Japan). This software was developed at the University of Tokyo
and Nagoya University.

==History

* 2011-8-3 Ver 2.00
  * Change format of helpfile from Windows help (*.hlp) to HTML help (*.chm).
  * Change Icons.
  * Change licence.
  * Documentations are revised.
* 2009-2-9 Ver 1.96
  * Bugs that Rotation and Controlled Rotation gates lost the factional part of phase were fixed.
* 2008-10-25 Ver 1.95
  * Rotation and Controlled Rotation gates become to accept non-integer value.
  * GUI for setting phase is implemented.
* 2008-10-02 Ver 1.94
  * Bugs in Controlled Rotation Gate are fixed.
  * Visualization on Result Window is optimized.
* 2007-5-25 Ver 1.93
  * Bugs in Undo are fixed.
  * Bugs in the form for modifying circuits are fixed.
* 2005-10-18 Ver 1.92
  * Measurement gates become available.
  * Bugs on shoing the help file is fixed.
* 2005-10-06 Ver 1.91
  * A problem using resource of Windows too much was fixed.
* 2005-07-28 Ver 1.90
  *A new function "Show Only NonZero" was implemented.
* 2005-05-01 Ver 1.89
  *Bugs on loading file was fixed.
* 2005-04-26 Ver 1.88
  * Bugs that Pauli Gates were ignored was fixed.
* 2005-04-26 Ver 1.87
  * Definitions of Rotation Gates in "Quantum Computation and Quantum Information" by M. A. Nielsen and I. L. Chuang are taken.
* 2005-04-21 Ver 1.86
  * Definitions of Z-Rotation Gates are revised.
* 2005-04-18 Ver 1.85
  * Bugs on a Z-Rotation a Controlled Z-Rotation Gates were fixed.
* 2005-03-17 Ver 1.84
  * Bugs on Rotation Gates were fixed.
  * Add Z Rotation Gate.
* 2005-03-14 Ver 1.83
  * Bugs on Pauli-Gates were fixed.
* 2004-10-27 Ver 1.82
  * Some messages were revised.
* 2004-09-15 Ver 1.81
  * Add scroll bar at the Result-View.
  * Add Save function on the Result-View.
  * Bugs on calculations were fixed.
* 2003-05-08 Ver 1.80
  * All Gates are availavle.
  * New views are now availavle.
  * Bugs of View were fixed.
* 2003-01-27 Ver 1.70
  * Bug of computation of "Controlled Rotate" is fixed.
  * Add Not Gate.
* 2003-01-22 Ver 1.60
  * Add "Undo" to Menu.
* 2002-12-31 Ver 1.50beta
  * Add Simulator on QCAD.
* 2002-06-24 Ver 1.00
  * Release First version.

((:<hr><div class=footer>QCAD<BR>Copyright &copy; 2002 - 2011 QCAD Developers Team. All rights reserved.<BR><a href="http://qcad.sourceforge.jp/">http://qcad.sourceforge.jp/</a></div>:))
=end
