//---------------------------------------------------------------------------
// Drawing Class
//---------------------------------------------------------------------------
#ifndef QDrawH
#define QDrawH

#include <vcl.h>
#pragma hdrstop
#include "QAbstractDraw.h"
//---------------------------------------------------------------------------
class QDraw : public QAbstractDraw {

private:
  TCanvas *Canvas;
  void SemiEllipse(int x1, int y1, int x2, int y2);

public:
  QDraw(TCanvas *_Canvas);
  ~QDraw(void);

  void SetCanvas(TCanvas *_Canvas) {Canvas=_Canvas;};
  //---------------------------------------------------------------------------
  // DrawingMethod (inherited)
  //---------------------------------------------------------------------------
  void DrawLine(int x1,int y1,int x2,int y2);
  void TextOut(int x,int y,std::string Text);
  void DrawCircle(int x1,int y1,int r);
  void DrawFillCircle(int x1,int y1,int r);
  void FrameRect(int x1,int y1,int x2,int y2);
  void FillRect(int x1,int y1,int x2,int y2);
  void DrawMeasure(int x,int y);
  //---------------------------------------------------------------------------
  // DrawingMethod (other)
  //---------------------------------------------------------------------------
  void SetPenColor(TColor Color) {Canvas->Pen->Color = Color;};
  void SetBrushColor(TColor Color) {Canvas->Brush->Color = Color;};
  void SetPenWidth(int w) {Canvas->Pen->Width = w;};

  void Ellipse(int x1,int y1,int x2,int y2);
  void DrawStepBar(int Line);
  void SetGridSize(int gsize);
  void DrawGrid(int ColumnNumber, int LineNumber);
  int GetPosX(int x) {return (x - LeftMargin)/GridSize;};
  int GetPosY(int y) {return (y - TopMargin)/GridSize;};
};
//---------------------------------------------------------------------------
#endif
