//---------------------------------------------------------------------------
#ifndef QManagerH
#define QManagerH
//---------------------------------------------------------------------------
#include "QCircuit.h"
#include "QBits.h"
#include "QDraw.h"
#include "QPSDraw.h"
#include "QSelector.h"
//---------------------------------------------------------------------------
typedef QCircuit* LPQCircuit;

class QUndoManager;

//---------------------------------------------------------------------------
struct PrintStatus {
  bool ShowIndexFlg;
  bool ShowVtLineFlg;

  PrintStatus(void) {
    ShowIndexFlg = true;
    ShowVtLineFlg = true;
  };
};
//---------------------------------------------------------------------------
class QManager {

private:
  QList qList;
  int **CircuitFlg;

  int LineNumber;    // the number of lines
  int ColumnNumber;  // the number of column
  int StepLine;

  bool **Occupied;
  bool Modified;
  string FileName;
  QSelector *qSelector;
  QUndoManager *qUndoManager;

  void InitCircuitFlg(int Line, int Column);
  string GetCalcText(void);
  void SaveMidCode(char *filename);
  void DeleteAll(void);
  bool Contains(QCircuit *qc);


public:
  QManager(void);
  ~QManager(void);

  static const int DEFAULT_LINE;
  static const int DEFAULT_COLUMN;

  string GetFileName(void){return FileName;};
  void SetFileName(string str){FileName = str;};
  void Init(int l,int c);
  PrintStatus PrtSt;
//---------------------------------------------------------------------------
  int GetLineNumber(void) {return LineNumber;};
  int GetColumnNumber(void) {return ColumnNumber;};
  bool IsModified(void) {return Modified;};
  void SetColumnNumber(int num) {ColumnNumber = num;};
//---------------------------------------------------------------------------
  int GetQCircuitCount(void);
  QCircuit* GetQCircuitAt(int index);
  void RemoveCircuit(QCircuit *qc);

  void Add(QCircuit *qc);
  void Remove(QCircuit *qc);
  void AddCircuit(QCircuit *qc);

  QCircuit* GetQCircuitAt(int x,int y);
//---------------------------------------------------------------------------
  void SaveToFile(char *filename);
  void LoadFromFile(const char *filename);

//---------------------------------------------------------------------------
// Edit
//---------------------------------------------------------------------------
  void Undo(QDraw *qDraw);
  void ReverseAll(void);

  QCircuit* GetCircuitInclude(int x, int y);
  void SetAllCircuitFlg(void);
  void ClrCircuitFlg(QCircuit* qc);
  bool CanPutCircuit(QCircuit* qc);

  void AddSelect(QCircuit *qc, QDraw *qDraw);
  void RemoveSelect(QDraw *qDraw);
  void RemoveSelectedCircuits(QDraw *qDraw);
//---------------------------------------------------------------------------
// Calculation
//---------------------------------------------------------------------------
  void CalcAll(QBits *qBits);
  void CalcAt(QBits *qBits,int Line);
  void CalcStep(QBits *qBits, QDraw *qDraw);

//---------------------------------------------------------------------------
// Drawing Method
//---------------------------------------------------------------------------
  void DrawAll(QDraw* Draw);
  void DrawStepBar(QDraw *qDraw);
  void DrawGridPrinter(QDraw *qDraw);
  void DrawAllPrinter(QDraw *qDraw);
  void DrawAllPS(QPSDraw* psDraw);

//---------------------------------------------------------------------------
  void Swap(QCircuit * qc0, QCircuit * qc1);
  void ModifyCircuit(QCircuit * qc0, QCircuit* qc1);
  void InsertColumn(int y, int width);
  void SaveAsEPS(const char *filename);
};
//---------------------------------------------------------------------------
#endif
