//---------------------------------------------------------------------------
#ifndef QSelectorH
#define QSelectorH

#include "QDraw.h"
#include "QCircuit.h"

//---------------------------------------------------------------------------
class QSelector {
private :
  QList qList;
  bool IsAdded(QCircuit *qc);
  void Remove(QCircuit *qc);

public :
  QSelector();
  ~QSelector();
  void Add(QCircuit *qc) {qList.push_back(qc);};
  void AddRemove(QCircuit *qc);
  void DeleteAll(void);
  int GetSelectedCount(void) {return qList.size();};
  QCircuit *GetSelectedCircuit(int index);
  void Select(QDraw *qd);
};
#endif
