//---------------------------------------------------------------------------
// Management class of Undo
//---------------------------------------------------------------------------
#include <algorithm>
#include "QUndoManager.h"
//---------------------------------------------------------------------------
/**
 * Constructor
 */
QUndoManager::QUndoManager(void) {
}
//---------------------------------------------------------------------------
/**
 * Destructor
 */
QUndoManager::~QUndoManager(void) {
}
//---------------------------------------------------------------------------
// Interface Methods
//---------------------------------------------------------------------------
void
QUndoManager::Add(QUndoUnit *qu) {
  uList.push_back(qu);
}
//---------------------------------------------------------------------------
int
QUndoManager::GetUndoCount(void) {
  return uList.size();
};
//---------------------------------------------------------------------------
void
QUndoManager::Remove(QUndoUnit *qu) {
  uList.erase(remove(uList.begin(), uList.end(), qu), uList.end());
};
//---------------------------------------------------------------------------
QUndoUnit *
QUndoManager::GetUndoUnitAt(int index) {
  return uList[index];
};
//---------------------------------------------------------------------------
void QUndoManager::Undo(QDraw *qDraw,QManager *qManager) {
  QUndoUnit *qu = GetUndoUnitAt(GetUndoCount()-1);
  qu->Undo(qManager);
  Remove(qu);
}
//---------------------------------------------------------------------------

