#include "QUndoQuitSelect.h"
//--------------------------------------------------------------------------
QUndoQuitSelect::QUndoQuitSelect(QSelector *qS) {
  qSelector = qS;
  Count = qSelector->GetSelectedCount();
  if (Count == 0) {
    return;
  }
  qX = new int[Count];
  qY = new int[Count];
  for (int i = 0; i < Count; i++) {
    QCircuit* qc = qSelector->GetSelectedCircuit(i);
    qX[i] = qc->GetX();
    qY[i] = qc->GetY();
  }
}
//--------------------------------------------------------------------------
QUndoQuitSelect::~QUndoQuitSelect() {
  delete [] qX;
  delete [] qY;
}
//--------------------------------------------------------------------------
void
QUndoQuitSelect::Undo(QManager *qManager) {
  qSelector->DeleteAll();
  for (int i = 0; i < Count; i++) {
    QCircuit *qc = qManager->GetQCircuitAt(qX[i], qY[i]);
    qSelector->Add(qc);
  }
}
//--------------------------------------------------------------------------

