/*
 *  qclib.cpp
 *  $Date: 2003/01/17 19:38:13 $
 *  $Revision: 1.2 $
 */
 
#include <iostream>
#include <cstdlib>
#include <cmath>
#include <new>
#include "qclib.h"
#include "qcunitcalc.h"
#include "QBits.h"

namespace qc {

static QBits    *gQBits         = NULL;
static int      gNumberOfQBits  = 0;
static double   *gRe            = NULL;
static double   *gIm            = NULL;
static bool     gInitialized    = false;

//----------------------------------------------------------------------------
/**
 *  Initialize qclib
 *  This function must be called at first.
 */
void allocWith(const QBits &qBits)
{
    try {
        gQBits          = new QBits(qBits);
        gNumberOfQBits  = gQBits->GetNumberOfQBits();
        gRe             = gQBits->GetBitsR();
        gIm             = gQBits->GetBitsI();
        gInitialized    = true;
    } catch (std::bad_alloc ex) {
        std::cerr << "qclib: failed in init.\n";
        std::exit(1);
    }
}

//----------------------------------------------------------------------------
/**
 *  Get qubits
 */
QBits *getQBits(void)
{
    if (false == gInitialized)
    {
        std::cerr << "qclib: you must initialized correctly.\n";
        std::exit(1);
    }
    return gQBits;
}

//----------------------------------------------------------------------------
/**
 *  Realease memory
 *  This function should be called in the end.
 */
void release(void)
{
    if (NULL != gQBits) delete gQBits;
    gQBits = NULL;
}
//----------------------------------------------------------------------------
} //qc
