// QBase.h
// 2009/06/04

#pragma once

#ifndef STDCALL
#define STDCALL __stdcall
#endif

/* */

// QPinHost
class QPinHost {

public:

	virtual ATL::CComCriticalSection& FilterCSec() = 0;

	virtual bool IsRunning() = 0;

}; /* QPinHost */

/* */

// QEvent
class QEvent {

	HANDLE m_hEvent;

public:

	QEvent() : m_hEvent(0)
	{
	}

	~QEvent()
	{
		Close();
	}

	operator HANDLE()
	{
		return m_hEvent;
	}

	HRESULT Create(bool init)
	{
		HANDLE h = CreateEventW(
			0,
			TRUE,
			init,
			0);
		if (h == 0) {
			DWORD error = GetLastError();
			return HRESULT_FROM_WIN32(error);
		}

		m_hEvent = h;

		return S_OK;
	}

	void Close()
	{
		if (m_hEvent != 0) {
			CloseHandle(m_hEvent);
			m_hEvent = 0;
		}
	}

	void SetEvent()
	{
		::SetEvent(m_hEvent);
	}

	void ResetEvent()
	{
		::ResetEvent(m_hEvent);
	}

}; // QEvent

/* */

