// QImageConverter.h
// 2009/06/03

#pragma once

enum QIType {
	IT_Unknown,

	IT_YUY2,
	IT_YV12,

	IT_Count
};

// QImageConverter
class QImageConverter {

	QIType m_Type;

	QTheoraCSC_t* m_csc;

	INT32 m_Stride;
	INT32 m_Rasters;

	INT32 m_x;
	INT32 m_y;

	INT32 m_cx;
	INT32 m_cy;

public:

	QImageConverter() :
		m_Type(IT_Unknown),
		m_csc(0),
		m_Stride(0),
		m_Rasters(0),
		m_x(0),
		m_y(0),
		m_cx(0),
		m_cy(0)
	{
		m_csc = QT_CreateCSC();
	}

	~QImageConverter()
	{
		QT_ReleaseCSC(m_csc);
	}

	void Setup(
		QIType             type,
		INT32              stride,
		INT32              rasters,
		const QT_Format_t* fmt)
	{
		m_Type = type;

		m_Stride  = stride;
		m_Rasters = (rasters >= 0) ? rasters : -rasters;

		m_x = fmt->PX;
		m_y = fmt->PY;

		m_cx = fmt->PW;
		m_cy = fmt->PH;

		switch (type) {
		case IT_YUY2:
			ATLTRACE("QImageConverter::Setup() : YUY2\n");
			QT_SetupCSC(m_csc, QTCS_YUY2);
			break;

		case IT_YV12:
			ATLTRACE("QImageConverter::Setup() : YV12\n");
			QT_SetupCSC(m_csc, QTCS_YV12);
			break;
		}
	}

	void Copy(
		VOID*            pv,
		const QT_Output* frame)
	{
		QT_Frame_t q = {
			pv,
			m_Stride,
			m_Rasters,
			m_x,
			m_y,
			m_cx,
			m_cy
		};

		switch (m_Type) {
		case IT_YUY2:
		case IT_YV12:
			QT_ConvertFrame(m_csc, frame, &q);
			break;

		} // switch
	}

}; // QImageConverter

