/* StreamView.h */
/* 2009/05/20   */

#pragma once

#include "MemoryAllocator.h"

#include "StreamReader.h"

/* */

struct StreamView {

	QM_Allocator_t* Allocator;

	QM_StreamReader_t* Reader;

	INT64 Pointer;

	UINT8* Buffer;
	INT32  Size;

	INT32 Current;
	INT32 Filled;

}; /* StreamView */

typedef struct StreamView StreamView_t;

struct StreamChunk {

	const UINT8* Buffer;

	INT32 start;
	INT32 mask;

	INT32 p;
	INT32 end;

}; /* StreamChunk */

typedef struct StreamChunk StreamChunk_t;

struct Element {

	INT32 Id;
	INT64 Size;

}; /* Element */

typedef struct Element Element_t;

/* */

BOOL StreamView_Create(
	StreamView_t*      t,
	QM_Allocator_t*    allocator,
	QM_StreamReader_t* reader,
	INT32              size);

void StreamView_Release(
	StreamView_t* t);

INT32 StreamView_Read(
	StreamView_t* t,
	INT32         size);

void StreamView_MapChunk(
	StreamView_t*  t,
	StreamChunk_t* chunk);

void StreamView_RetireChunk(
	StreamView_t*  t,
	StreamChunk_t* chunk);

INT64 StreamView_TellPosition(
	StreamView_t* t);

/* */

BOOL StreamView_Seek(
	StreamView_t* t,
	INT64         pos);

BOOL StreamView_LoadElement(
	StreamView_t*  t,
	INT32          id,
	StreamChunk_t* chunk,
	Element_t*     e);

BOOL StreamView_CheckElement(
	StreamView_t*  t,
	INT32          id,
	StreamChunk_t* chunk,
	Element_t*     e);

BOOL StreamView_ReadElement(
	StreamView_t*  t,
	StreamChunk_t* chunk,
	Element_t*     e);

/* */

INT32 StreamChunk_GetElementId(
	StreamChunk_t* t);

INT64 StreamChunk_GetElementSize(
	StreamChunk_t* t);

BOOL StreamChunk_GetElement(
	StreamChunk_t* t,
	Element_t*     e);

BOOL StreamChunk_GetBinaryData(
	StreamChunk_t* t,
	VOID*          pv,
	INT64          size);

BOOL StreamChunk_GetInt32Data(
	StreamChunk_t* t,
	INT32*         value,
	INT64          size);

BOOL StreamChunk_GetSInt32Data(
	StreamChunk_t* t,
	INT32*         value,
	INT64          size);

BOOL StreamChunk_GetInt64Data(
	StreamChunk_t* t,
	INT64*         value,
	INT64          size);

BOOL StreamChunk_GetFloatData(
	StreamChunk_t* t,
	DOUBLE*        value,
	INT64          size);

BOOL StreamChunk_CopyBinaryData(
	StreamChunk_t* t,
	VOID*          pv,
	INT64          size);

/* */

BOOL StreamChunk_CheckSize(
	StreamChunk_t* t,
	INT64          size);

BOOL StreamChunk_Skip(
	StreamChunk_t* t,
	INT64          size);

INT32 StreamChunk_GetEndPoint(
	StreamChunk_t* t,
	INT64          size);

INT32 StreamChunk_CheckEndPoint(
	StreamChunk_t* t,
	INT32          ep);

/* */

