/* BlockIndex.h */
/* 2009/05/14   */

#pragma once

#include "MemoryPool.h"

/* BlockIndex */
struct BlockIndex {

	INT32 MX;
	INT32 MY;
	INT32 MC;

	INT32 BX[3];
	INT32 BY[3];
	INT32 BC[3];

	INT32 SX[3];
	INT32 SY[3];
	INT32 SC[3];

	UINT16* BIndex[3];
	UINT8*  BCount[3];

	UINT16* MBIndex;

	UINT16* CBIndex;

	INT32 Blocks;
	INT32 SBlocks;

}; /* BlockIndex */

typedef struct BlockIndex BlockIndex_t;

BOOL BlockIndex_Setup(
	BlockIndex_t* t,
	MemoryPool_t* pool,
	INT32         mx,
	INT32         my);

