/* SetupDecoder.h */
/* 2009/06/26     */

#pragma once

#include "BitReader.h"

#include "MemoryPool.h"

/* QT_IdentifyHeader */
struct QT_IdentifyHeader {

	UINT8 Version[4];

	INT32 MX;
	INT32 MY;

	INT32 PCX;
	INT32 PCY;
	INT32 PDX;
	INT32 PDY;

	UINT32 FRN;
	UINT32 FRD;

	UINT32 PRN;
	UINT32 PRD;

	INT32 NOMBR;

	UINT8 CS;
	UINT8 QUAL;
	UINT8 KFGSHIFT;
	UINT8 PF;

}; /* QT_IdentifyHeader */

typedef struct QT_IdentifyHeader IdentifyHeader_t;

/* FilterTable */
struct FilterTable {

	UINT8 Limit[64];

}; /* FilterTable */

typedef struct FilterTable FilterTable_t;

/* DequantizeTable */
struct DequantizeTable {

	UINT16 ACScale[64];
	UINT16 DCScale[64];

	UINT8 Matrix[384][64];

	UINT8 Count[2][3];

	UINT8  Size[2][3][64];
	UINT16 Base[2][3][64];

}; /* DequantizeTable */

typedef struct DequantizeTable DequantizeTable_t;

/* */

#define HUFFMAN_SIZE 32
#define BITS_COUNT   32

/* QT_HuffmanTable */
struct QT_HuffmanTable {

	UINT32 Code  [HUFFMAN_SIZE];
	UINT8  Length[HUFFMAN_SIZE];
	UINT8  Index [HUFFMAN_SIZE];

}; /* QT_HuffmanTable */

typedef struct QT_HuffmanTable HuffmanTable_t;

/* QT_HuffmanDecoder */
struct QT_HuffmanDecoder {

	INT8   Index[BITS_COUNT];
	INT8   Count[BITS_COUNT];
	UINT32 Code [HUFFMAN_SIZE];
	UINT8  Token[HUFFMAN_SIZE];

	INT32 LookupBits;
	INT8* LookupToken;
	INT8* LookupLength;

}; /* QT_HuffmanDecoder */

typedef struct QT_HuffmanDecoder HuffmanDecoder_t;

/* */

/* QT_SetupHeader */
struct QT_SetupHeader {

	FilterTable_t Filter;

	DequantizeTable_t Dequantize;

	HuffmanDecoder_t Huffman[80];

}; /* QT_SetupHeader */

typedef struct QT_SetupHeader SetupHeader_t;

/* */

BOOL QT_SetupDecoderSetupLacing_C(
	IdentifyHeader_t* id,
	SetupHeader_t*    setup,
	MemoryPool_t*     pool,
	BitReader_C_t*    d);

BOOL QT_SetupDecoderSetupLacing_X86(
	IdentifyHeader_t* id,
	SetupHeader_t*    setup,
	MemoryPool_t*     pool,
	BitReader_X86_t*  d);

BOOL QT_SetupDecoderSetupLacing_MMX(
	IdentifyHeader_t* id,
	SetupHeader_t*    setup,
	MemoryPool_t*     pool,
	BitReader_MMX_t*  d);

/* */

