/* TheoraDecoder.h */
/* 2009/06/26      */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

BOOL QT_Initialize(void);

BOOL QT_SetEnableX86(BOOL b);
BOOL QT_SetEnableMMX(BOOL b);
BOOL QT_SetEnableSSE2(BOOL b);

/* */

struct QTheoraDecoderSetup;

typedef struct QTheoraDecoderSetup QTheoraDecoderSetup_t;

QTheoraDecoderSetup_t* QT_CreateDecoderSetup(void);

void QT_ReleaseDecoderSetup(QTheoraDecoderSetup_t* setup);

BOOL QT_SetupDecoderSetupLacing(
	QTheoraDecoderSetup_t* setup,
	const VOID*            packet,
	SIZE_T                 size);

/* */

struct QT_Format {

	INT32 CX;
	INT32 CY;

	INT32 PX;
	INT32 PY;
	INT32 PW;
	INT32 PH;

	INT32 FRN;
	INT32 FRD;

	INT32 PRN;
	INT32 PRD;

};

typedef struct QT_Format QT_Format_t;

BOOL QT_GetFormatSetup(
	QTheoraDecoderSetup_t* setup,
	QT_Format_t*           format);

/* */

struct QTheoraDecoder;

typedef struct QTheoraDecoder QTheoraDecoder_t;

QTheoraDecoder_t* QT_CreateDecoder(void);

void QT_ReleaseDecoder(QTheoraDecoder_t* d);

BOOL QT_SetupDecoder(
	QTheoraDecoder_t*      d,
	QTheoraDecoderSetup_t* setup);

struct QT_Output {

	const UINT8* Plane[3];

	INT32 CX;
	INT32 CY;

};

typedef struct QT_Output QT_Output_t;

BOOL QT_DecodeFrame(
	QTheoraDecoder_t* d,
	const VOID*       packet,
	SIZE_T            size,
	QT_Output_t*      output);

/* */

#define QTCS_YV12 0
#define QTCS_YUY2 1

struct QTheoraCSC;

typedef struct QTheoraCSC QTheoraCSC_t;

QTheoraCSC_t* QT_CreateCSC(void);

void QT_ReleaseCSC(QTheoraCSC_t* t);

BOOL QT_SetupCSC(
	QTheoraCSC_t* t,
	INT32         cs);

struct QT_Frame {

	VOID*  Frame;
	INT32  Pitch;
	INT32  Rasters;

	INT32 X;
	INT32 Y;

	INT32 CX;
	INT32 CY;

};

typedef struct QT_Frame QT_Frame_t;

BOOL QT_ConvertFrame(
	QTheoraCSC_t*      t,
	const QT_Output_t* output,
	QT_Frame_t*        frame);

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

