// Main.cpp
// 2009/05/29

#include "StdAfx.h"

#include <crtdbg.h>

#include "TheoraDecoder.h"
#include "VorbisDecoder.h"

/* */

#include "MainDialog.h"

/* */

WTL::CAppModule _Module;

/* */

int DoProcess();

/* */

int WINAPI wWinMain(
	HINSTANCE hInstance,
	HINSTANCE /*hPrevInstance*/,
	LPWSTR    /*lpCmdLine*/,
	int       /*nCmdShow*/)
{
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);
	// _CrtSetBreakAlloc(1);

	HRESULT hRslt = OleInitialize(0);
	if (FAILED(hRslt)) {
		return -1;
	}

	_Module.Init(0, hInstance);

	int result = DoProcess();

	_Module.Term();

	OleUninitialize();

	return result;
}

/* */

static bool DoInitialize();
static void DoUninitialize();
static int  DoMain();

int DoProcess()
{
	int result = -1;

	if (DoInitialize()) {
		result = DoMain();
	}

	DoUninitialize();

	return result;
}

/* */

static bool DoInitialize()
{
	if (!QT_Initialize()) {
		return false;
	}

	if (!QV_Initialize()) {
		return false;
	}

	return true;
}

static void DoUninitialize()
{
}

/* */

static int DoMain()
{
	int result = -1;

	WTL::CMessageLoop theLoop;
	_Module.AddMessageLoop(&theLoop);

	{
		MainDialog dlg;

		theLoop.AddMessageFilter(&dlg);

		HWND hwnd = dlg.Create(0);
		if (hwnd != 0) {
			dlg.ShowWindow(SW_NORMAL);
			dlg.UpdateWindow();

			result = theLoop.Run();
		}

		theLoop.RemoveMessageFilter(&dlg);
	}

	_Module.RemoveMessageLoop();

	return result;
}

/* */

