// Main.cpp
// 2009/06/26

#include "StdAfx.h"

#include <conio.h>

#include "Matroska.h"
#include "TheoraDecoder.h"

#include "YUVReader.h"

class TestApp {

	QM_Reader_t* m_reader;

	INT32 m_vid;

	INT64 m_vd;

	QTheoraDecoderSetup_t* m_vsetup;

	QTheoraDecoder_t* m_vdecoder;

	YUVReader* m_yuv;

public:

	TestApp() : m_reader(0), m_vid(0), m_vd(0),
		m_vsetup(0), m_vdecoder(0), m_yuv(0)
	{
	}

	~TestApp()
	{
		QM_ReleaseReader(m_reader);

		QT_ReleaseDecoder(m_vdecoder);
		QT_ReleaseDecoderSetup(m_vsetup);

		delete m_yuv;
	}

	bool Setup(LPCWSTR mkv, LPCWSTR yuv)
	{
		m_reader = QM_CreateReader();
		if (m_reader == 0) {
			return false;
		}

		if (!QM_OpenReader(m_reader, mkv)) {
			return false;
		}

		if (!CheckVideo()) {
			return false;
		}

		if (m_vid != 0 && yuv != 0) {
			m_yuv = new YUVReader();

			if (!m_yuv->Open(yuv)) {
				puts("YUV open error.");
				return false;
			}
		}

		return true;
	}

	bool Decode()
	{
		INT32 i = 0;

		DWORD start = timeGetTime();

		DWORD dtime = 0;

		for (; ; ) {
			QM_Block_t block;
			INT32 code = QM_ReadBlock(
				m_reader,
				&block);
			if (code < 0) {
				puts("QM_ReadBlock() Error");
				return false;
			}
			if (code == 0) {
				break;
			}

			if (block.TrackNo == m_vid) {
#ifdef _DEBUG
				printf("F: %d : 0x%x\n", i, block.Flags);
#endif

				DWORD ds = timeGetTime();

				QT_Output_t output = { 0 };
				if (!QT_DecodeFrame(
					m_vdecoder,
					block.Payload,
					block.Size,
					&output)) {
					puts("QT_DecodeFrame() Error");
					return false;
				}

				DWORD de = timeGetTime();

				dtime += de - ds;

				i++;

				if (m_yuv != 0) {
#if 1
					INT32 df = 0;
					while (df < 300) {
						if (Compare(&output)) {
							break;
						}
						df++;
						printf("Skip: %d\n", df);
					}

					if (df >= 300) {
						printf("ERROR Compare : %d\n", i);

						return false;
					}
#else
					if (!Compare(&output)) {
						printf("ERROR Compare : %d\n", i);
					}
#endif

				}

#ifdef _DEBUG
				if (i >= 10) {
					break;
				}
#endif

			}
		}

		DWORD end = timeGetTime();

		if (i > 0) {
			DWORD elapsed = end - start;

			INT64 t = ((INT64)elapsed * 10) / i;

			printf("Frames: %d\n", i);
			printf("Time:   %d ms / %d ms\n", elapsed, dtime);
			printf("FTime:  %d.%01d ms\n", (INT32)(t / 10), (INT32)(t % 10));

			INT64  ft = ((INT64)elapsed * 1000*1000) / i;
			DOUBLE fr = (DOUBLE)m_vd / ft;
			printf("FRate:  %lg\n", fr);
		}

		return true;
	}

private:

	bool Compare(QT_Output_t* output)
	{
		if (!m_yuv->ReadFrame()) {
			return false;
		}

		if (!m_yuv->Compare(output)) {
			return false;
		}

		return true;
	}

	bool CheckVideo()
	{
		const QM_Track_t* track = QM_GetTracks(m_reader);
		const QM_Track_t* end = track + QM_GetTrackCount(m_reader);

		for (; track < end; track++) {
			if (strcmp(track->CodecId, "V_THEORA") == 0) {
				m_vsetup = QT_CreateDecoderSetup();
				if (m_vsetup == 0) {
					return false;
				}

				if (!QT_SetupDecoderSetupLacing(
					m_vsetup,
					track->CodecPrivate,
					track->CodecPrivateSize)) {
					return false;
				}

				m_vdecoder = QT_CreateDecoder();
				if (m_vdecoder == 0) {
					return false;
				}

				if (!QT_SetupDecoder(m_vdecoder, m_vsetup)) {
					return false;
				}

				m_vid = track->TrackNo;

				m_vd = track->TrackDuration;

				break;
			}
		}

		if (m_vid == 0) {
			puts("No Video");
		}

		return true;
	}

};

int wmain(int argc, wchar_t* argv[])
{
	if (!QT_Initialize()) {
		return -1;
	}

	LPCWSTR mkv = 0;
	LPCWSTR yuv = 0;

	bool no_SSE2 = false;
	bool no_MMX  = false;

	for (INT32 i = 1; i < argc; i++) {
		LPCWSTR a = argv[i];
		if (wcscmp(a, L"-n") == 0) {
			no_SSE2 = true;
			continue;
		}

		if (wcscmp(a, L"-m") == 0) {
			no_MMX = true;
			continue;
		}

		if (mkv == 0) {
			mkv = a;
		} else if (yuv == 0) {
			yuv = a;
		}
	}

	if (mkv == 0) {
		puts("TBenchEx [input mkv] (ref yuv)");
		puts(" -n No SSE2");
		puts(" -m No MMX");
		return -1;
	}

	if (no_SSE2) {
		QT_SetEnableSSE2(FALSE);
	}

	if (no_MMX) {
		QT_SetEnableMMX(FALSE);
	}

	SetThreadAffinityMask(GetCurrentThread(), 1);

	TestApp app;
	if (!app.Setup(mkv, yuv)) {
		return -1;
	}

	if (!app.Decode()) {
		puts("NG.");
		return -1;
	}

	puts("DONE.");

#if 0
	_getch();
#endif

	return 0;
}

