/* SamplesChecker.h */
/* 2008/11/18       */

#pragma once

#include "DecoderSetup.h"

/* */

struct SamplesChecker {

	/* ID */

	INT32 Channels;
	INT32 SampleRate;

	INT32 BlockSize0;
	INT32 BlockSize1;

	/* Mode Setup */

	INT32 ModeCount;
	INT32 ModeBits;

	UINT32 BlockFlags;

	/* Context */

	INT32 BlockSize;
	INT32 PrevBlockSize;

};

typedef struct SamplesChecker SamplesChecker_t;

/* */

BOOL SamplesChecker_Setup(
	const DecoderSetup_t* setup,
	SamplesChecker_t*     t);

void SamplesChecker_Reset(
	SamplesChecker_t* t);

BOOL SamplesChecker_CheckFrame(
	SamplesChecker_t* t,
	const VOID*       frame,
	INT32             size,
	INT32*            samples);

/* */

