// QDSAudio.cpp
// 2009/08/21

#include "StdAfx.h"

#include <initguid.h>

#include "VorbisDecoder.h"

#include "OggVorbis.h"
#include "TTAReader.h"

#include "QDSAudio.h"

#include "QMediaType.h"
#include "QPinEnum.h"

#include "QWaveOutputer.h"

#include "QReader.h"

#include "QStreamer.h"

#include "QPin.h"
#include "QFilter.h"

/* */

#ifdef QDSAUDIO_BUILD_DLL

// Module
class Module : public ATL::CAtlDllModuleT<Module> {

}; // Module

Module _AtlModule;

#endif

/* */

static HRESULT InitModule()
{
#ifdef QDSAUDIO_BUILD_DLL
	static bool s_init = true;
	if (s_init) {
		if (!QV_Initialize()) {
			return E_OUTOFMEMORY;
		}
		s_init = false;
	}
#endif

	return S_OK;
}

/* */

HRESULT QDSA_CreateOggVorbisDecoder(
	LPCWSTR       path,
	IBaseFilter** ppFilter)
{
	HRESULT hRslt = InitModule();
	if (FAILED(hRslt)) {
		return hRslt;
	}

	ATL::CComObject<QFilter>* filter = 0;
	hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->OpenVorbis(path);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

HRESULT QDSA_CreateOggVorbisDecoder_IStream(
	IStream*      p,
	IBaseFilter** ppFilter)
{
	HRESULT hRslt = InitModule();
	if (FAILED(hRslt)) {
		return hRslt;
	}

	ATL::CComObject<QFilter>* filter = 0;
	hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->OpenVorbis(p);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

HRESULT QDSA_CreateTTADecoder(
	LPCWSTR       path,
	IBaseFilter** ppFilter)
{
	HRESULT hRslt = InitModule();
	if (FAILED(hRslt)) {
		return hRslt;
	}

	ATL::CComObject<QFilter>* filter = 0;
	hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->OpenTTA(path);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

HRESULT QDSA_CreateTTADecoder_IStream(
	IStream*      p,
	IBaseFilter** ppFilter)
{
	HRESULT hRslt = InitModule();
	if (FAILED(hRslt)) {
		return hRslt;
	}

	ATL::CComObject<QFilter>* filter = 0;
	hRslt = ATL::CComObject<QFilter>::CreateInstance(&filter);
	if (FAILED(hRslt)) {
		return hRslt;
	}

	hRslt = filter->OpenTTA(p);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	hRslt = filter->QueryInterface(ppFilter);
	if (FAILED(hRslt)) {
		delete filter;
		return hRslt;
	}

	return S_OK;
}

/* */

HRESULT QDSA_SetupLoopPoint(
	IBaseFilter* pFilter,
	INT64        pos)
{
	ATL::CComObject<QFilter>* filter = static_cast<ATL::CComObject<QFilter>*>(pFilter);
	if (filter != 0) {
		filter->SetupLoopPoint(pos);
	}

	return S_OK;
}

/* */

void QDSA_FreeMediaType(
	AM_MEDIA_TYPE* mt)
{
	QMediaType::Free(mt);
}

/* */

