// OVKReader.cs
// 2008/11/18

using System;
using System.IO;
using System.Collections.Generic;

namespace VA {

// OVKItem
public struct OVKItem {

	public UInt32 Sequence;
	public UInt32 Offset;
	public UInt32 Size;
	public UInt32 Samples;

} // OVKItem

// OVKReader
public class OVKReader {

	private Stream _s;

	private OVKItem[] _items;

	public OVKReader(Stream s)
	{
		_s = s;
	}

	public void ReadHeader()
	{
		Byte[] by = new Byte[4 * 4];

		_s.Read(by, 0, 4);
		UInt32 count = BitConverter.ToUInt32(by, 0);

		_items = new OVKItem[count];

		for (UInt32 i = 0; i < count; i++) {
			_s.Read(by, 0, 4 * 4);

			_items[i].Size     = BitConverter.ToUInt32(by, 0 * 4);
			_items[i].Offset   = BitConverter.ToUInt32(by, 1 * 4);
			_items[i].Sequence = BitConverter.ToUInt32(by, 2 * 4);
			_items[i].Samples  = BitConverter.ToUInt32(by, 3 * 4);
		}
	}

	public Int32 Count {
		get { return _items.Length; }
	}

	public String GetName(Int32 index)
	{
		return _items[index].Sequence.ToString();
	}

	public Stream CreateStream(Int32 index)
	{
		Byte[] by = new Byte[_items[index].Size];

		_s.Seek(
			_items[index].Offset,
			SeekOrigin.Begin);

		_s.Read(by, 0, by.Length);

		return new MemoryStream(by);
	}

} // OVKReader

} // namespace VA

