/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;


/**
 * Short hand Methods.
 * 
 * @author senju
 *
 */
public final class Sht {

	public static final User user(){
		UserService userService = UserServiceFactory.getUserService();
		return userService.getCurrentUser();
	}
	
	public static final String loginUrl(HttpServletRequest req){
		UserService userService = UserServiceFactory.getUserService();
		return userService.createLoginURL(req.getRequestURI());
	}
	
	public static final String logoutUrl(HttpServletRequest req){
		UserService userService = UserServiceFactory.getUserService();
		return userService.createLogoutURL(req.getRequestURI());
	}
	
	@SuppressWarnings("unchecked")
	public static final Logger log(Class c){
		return LoggerFactory.getLogger(c.getName());
	}
	
	public static final Logger log(Object o){
		return LoggerFactory.getLogger(o.getClass().getName());
	}
}
