/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.dao.jdo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

import jp.sourceforge.rabbitBTS.dao.GenericDao;

import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.jdo.support.JdoDaoSupport;

import com.google.appengine.api.datastore.Key;

public class GenericDaoJdo<T, PK extends Serializable> extends JdoDaoSupport
		implements GenericDao<T, PK> {
	public final Class<T> persistentClass;

	/**
	 * Constructor that takes in a class for easy creation of DAO
	 */
	public GenericDaoJdo(Class<T> persistentClass) {
		this.persistentClass = persistentClass;
	}

	public boolean exists(PK id) {
		try {
			getJdoTemplate().getObjectById(this.persistentClass, id);
			return true;
		} catch (final ObjectRetrievalFailureException e) {
			return false;
		}
	}

	@SuppressWarnings("unchecked")
	public T get(PK id) {
		final T entity = (T) getJdoTemplate().getObjectById(
				this.persistentClass, id);
		return entity;
	}

	@SuppressWarnings("unchecked")
	public T getByKey(Key id) {
		final T entity = (T) getJdoTemplate().getObjectById(
				this.persistentClass, id);
		return entity;
	}

	public List<T> getAll() {
		return new ArrayList<T>(getJdoTemplate().find(this.persistentClass));
	}

	public List<T> getAllDistinct() {
		final Collection result = new LinkedHashSet(getAll());
		return new ArrayList(result);
	}

	public void remove(PK id) {
		getJdoTemplate().deletePersistent(this.get(id));
	}

	public T save(T object) {
		return (T) getJdoTemplate().makePersistent(object);
	}

}
