#! /usr/bin/python
# vim:set expandtab ts=4 sts=4 sw=4 tw=0 fileencoding=utf-8:

import sys
sys.path.append(pathToSeleniumPythonDriver)

from selenium import selenium
import unittest, time, re

class Untitled(unittest.TestCase):
    def setUp(self):
        self.verificationErrors = []
        self.selenium = selenium("localhost", 4444, "*firefox", "http://localhost:8080/")
        self.selenium.start()
    def logoutAndDeleteUser(self):
        sel = self.selenium
        sel.open("/index.html")
        self.assertEqual(u"[Rabbit BTS] サイトトップ", sel.get_title())
        sel.click("link=data viewer")
        sel.wait_for_page_to_load("30000")
        self.assertEqual("rabbit-bts Development Console - Datastore Viewer", sel.get_title())
        sel.select("kind_input", "label=BbsPost")
        sel.click("list_button")
        sel.wait_for_page_to_load("30000")
        self.assertEqual("rabbit-bts Development Console - Datastore Viewer", sel.get_title())
        sel.select("kind_input", "label=Account")
        sel.click("list_button")
        sel.wait_for_page_to_load("30000")
        self.assertEqual("rabbit-bts Development Console - Datastore Viewer", sel.get_title())
        sel.click("allkeys")
        sel.click("delete_button")
        self.failUnless(re.search(r"^Are you sure you wish to delete these entities[\s\S]$", sel.get_confirmation()))
        self.assertEqual("rabbit-bts Development Console - Datastore Viewer", sel.get_title())
        sel.click("list_button")
        sel.wait_for_page_to_load("30000")
        self.assertEqual("rabbit-bts Development Console - Datastore Viewer", sel.get_title())
        sel.open("/index.html")
        self.assertEqual(u"[Rabbit BTS] サイトトップ", sel.get_title())

    def test_register(self):
        self.logoutAndDeleteUser()
        sel = self.selenium
        sel.open("/index.html")
        sel.wait_for_page_to_load("30000")
        self.failUnless(sel.is_text_present(u"サイトトップ"))
        sel.click("logo")
        sel.wait_for_page_to_load("30000")
        self.failUnless(sel.is_text_present(u"サイトトップ"))
        sel.click("link=BBS")
        sel.wait_for_page_to_load("30000")
        sel.type("email", "test@example.com")
        sel.click(u"//input[@value='Log In']")
        sel.wait_for_page_to_load("30000")
        self.failUnless(sel.is_text_present(u"ユーザー登録"))
        sel.type("nickName", "\"><script>alert(\"hoge\")</script>")
        sel.click(u"//input[@value='登録']")
        sel.wait_for_page_to_load("30000")
        self.failIf(sel.is_alert_present())
        sel.type("nickName", "")
        sel.click(u"//input[@value='登録']")
        sel.wait_for_page_to_load("30000")
        self.failUnless(sel.is_text_present(u"ニックネームを入力せよ"))
        self.failUnless(sel.is_text_present(u"自己紹介を入力せよ"))
        sel.type("nickName", "selenium")
        sel.type("bio", u"自己紹介")
        sel.click(u"//input[@value='登録']")
        sel.wait_for_page_to_load("30000")
        sel.open("/index.html")

    def tearDown(self):
        self.selenium.stop()
        self.assertEqual([], self.verificationErrors)

if __name__ == "__main__":
    unittest.main()
