// TsDescrambler.cpp: CTsDescrambler NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TsDescrambler.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// CTsDescrambler \z/
//////////////////////////////////////////////////////////////////////

CTsDescrambler::CTsDescrambler(CDecoderHandler *pDecoderHandler)
	: CMediaDecoder(pDecoderHandler)
	, m_dwInputPacketCount(0UL)
	, m_dwScramblePacketCount(0UL)
{
	// PATe[uPID}bvǉ
	m_PidMapManager.MapTarget(0x0000U, new CPatTable, CTsDescrambler::OnPatUpdated, static_cast<PVOID>(this));
}

CTsDescrambler::~CTsDescrambler()
{
	CloseBcasCard();
}

void CTsDescrambler::Reset(void)
{
	// Ԃ
	m_PidMapManager.UnmapAllTarget();

	// PATe[uPID}bvǉ
	m_PidMapManager.MapTarget(0x0000U, new CPatTable, CTsDescrambler::OnPatUpdated, static_cast<PVOID>(this));

	// vf[^
	m_dwInputPacketCount = 0UL;
	m_dwScramblePacketCount = 0UL;

	// fR[_
	CMediaDecoder::Reset();
}

const DWORD CTsDescrambler::GetInputNum(void) const
{
	return 1UL;
}

const DWORD CTsDescrambler::GetOutputNum(void) const
{
	return 1UL;
}

const bool CTsDescrambler::InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex)
{
	if(dwInputIndex >= GetInputNum())return false;

	CTsPacket *pTsPacket = dynamic_cast<CTsPacket *>(pMediaData);

	// ̓fBAf[^͌݊Ȃ
	if(!pTsPacket)return false;

	// ̓pPbgJEg
	if(m_dwInputPacketCount < 0xFFFFFFFFUL)m_dwInputPacketCount++;

	// PID[eBO
	m_PidMapManager.StorePacket(pTsPacket);

	// pPbgo
	if(pTsPacket->IsScrambled()){
		// RpPbgJEg
		if(m_dwScramblePacketCount < 0xFFFFFFFFUL)m_dwScramblePacketCount++;
	} else {

		// pPbgfR[_Ƀf[^n
		OutputMedia(pMediaData);
	}

	return true;
}

const bool CTsDescrambler::OpenBcasCard(DWORD *pErrorCode)
{
	// J[h[_B-CASJ[hĊJ
	const bool bReturn = m_BcasCard.OpenCard();
	
	// G[R[hZbg
	if(pErrorCode)*pErrorCode = m_BcasCard.GetLastError();

	return bReturn;
}

void CTsDescrambler::CloseBcasCard(void)
{
	// B-CASJ[h
	m_BcasCard.CloseCard();
}

const bool CTsDescrambler::GetBcasCardID(BYTE *pCardID)
{
	// J[hID擾
	const BYTE *pBuff = m_BcasCard.GetBcasCardID();
	
	// obt@ɃRs[
	if(pCardID && pBuff)::CopyMemory(pCardID, pBuff, 6UL);
	
	return (pBuff)? true : false;
}

const DWORD CTsDescrambler::GetInputPacketCount(void) const
{
	// ̓pPbgԂ
	return m_dwInputPacketCount;
}

const DWORD CTsDescrambler::GetScramblePacketCount(void) const
{
	// RpPbgԂ
	return m_dwScramblePacketCount;
}

void CALLBACK CTsDescrambler::OnPatUpdated(const WORD wPID, CTsPidMapTarget *pMapTarget, CTsPidMapManager *pMapManager, const PVOID pParam)
{
	// PATXVꂽ
	CPatTable *pPatTable = dynamic_cast<CPatTable *>(pMapTarget);

#ifdef _DEBUG
	if(!pPatTable)::DebugBreak();
#endif

	// PMTe[uPID}bvǉ
	for(WORD wIndex = 0U ; wIndex < pPatTable->GetProgramNum() ; wIndex++){
		pMapManager->MapTarget(pPatTable->GetPmtPID(wIndex), new CPmtTable, CTsDescrambler::OnPmtUpdated, pParam);
		}
}

void CALLBACK CTsDescrambler::OnPmtUpdated(const WORD wPID, CTsPidMapTarget *pMapTarget, CTsPidMapManager *pMapManager, const PVOID pParam)
{
	// PMTXVꂽ
	CTsDescrambler *pThis = static_cast<CTsDescrambler *>(pParam);
	CPmtTable *pPmtTable = dynamic_cast<CPmtTable *>(pMapTarget);

#ifdef _DEBUG
	if(!pPmtTable)::DebugBreak();
#endif

	// ECMPID}bvǉ
	const WORD wEcmPID = pPmtTable->GetEcmPID();
	if(wEcmPID >= 0x1FFFU)return;

	// ECM^[QbgmF
	CEcmProcessor *pEcmProcessor = dynamic_cast<CEcmProcessor *>(pMapManager->GetMapTarget(wEcmPID));

	if(!pEcmProcessor){
		// ECMNXVK}bv
		pEcmProcessor = new CEcmProcessor(&pThis->m_BcasCard);
		pMapManager->MapTarget(wEcmPID, pEcmProcessor);
		}
	
	// ESPID}bvǉ
	for(WORD wIndex = 0U ; wIndex < pPmtTable->GetEsInfoNum() ; wIndex++){
		pMapManager->MapTarget(pPmtTable->GetEsPID(wIndex), new CEsProcessor(pEcmProcessor), NULL, pParam);
		}
}


//////////////////////////////////////////////////////////////////////
// CTsDescrambler::CEcmProcessor \z/
//////////////////////////////////////////////////////////////////////

CTsDescrambler::CEcmProcessor::CEcmProcessor(CBcasCard *pBcasCard)
	: CDynamicReferenceable()
	, CPsiSingleTable(true)
	, m_pBcasCard(pBcasCard)
	, m_bLastEcmSucceed(true)
{
	// MULTI2fR[_ɃVXeL[ƏCBCZbg
	m_Multi2Decoder.Initialize(m_pBcasCard->GetSystemKey(), m_pBcasCard->GetInitialCbc());
}

void CTsDescrambler::CEcmProcessor::OnPidMapped(const WORD wPID, const PVOID pParam)
{
	// QƃJEgǉ
	AddRef();
}

void CTsDescrambler::CEcmProcessor::OnPidUnmapped(const WORD wPID)
{
	// QƃJEgJ
	ReleaseRef();
}

const bool CTsDescrambler::CEcmProcessor::DescramblePacket(CTsPacket *pTsPacket)
{
	// XNu
	if(m_Multi2Decoder.Decode(pTsPacket->GetPayloadData(), (DWORD)pTsPacket->GetPayloadSize(), pTsPacket->m_Header.byTransportScramblingCtrl)){
		// gX|[gXNuĐݒ
		pTsPacket->SetAt(3UL, pTsPacket->GetAt(3UL) & 0x3FU);
		pTsPacket->m_Header.byTransportScramblingCtrl = 0U;
		return true;
		}
	
	return false;
}

const bool CTsDescrambler::CEcmProcessor::OnTableUpdate(const CPsiSection *pCurSection, const CPsiSection *pOldSection)
{
	// ECMB-CASJ[hɓnăL[擾
	const BYTE *pKsData = m_pBcasCard->GetKsFromEcm(pCurSection->GetPayloadData(), pCurSection->GetPayloadSize());

	// ECMs͈xB-CASJ[hď
	if(!pKsData && m_bLastEcmSucceed && (m_pBcasCard->GetLastError() != BCEC_ECMREFUSED)){
		if(m_pBcasCard->OpenCard()){
			pKsData = m_pBcasCard->GetKsFromEcm(pCurSection->GetPayloadData(), pCurSection->GetPayloadSize());
			}
		}

	// XNuL[XV
	m_Multi2Decoder.SetScrambleKey(pKsData);

	// ECMԍXV
	m_bLastEcmSucceed = (pKsData)? true : false;

	return true;
}


//////////////////////////////////////////////////////////////////////
// CTsDescrambler::CEsProcessor \z/
//////////////////////////////////////////////////////////////////////

CTsDescrambler::CEsProcessor::CEsProcessor(CTsDescrambler::CEcmProcessor *pEcmProcessor)
	: CTsPidMapTarget()
	, m_pEcmProcessor(pEcmProcessor)
{
	// QƃJEgǉ
	m_pEcmProcessor->AddRef();
}

CTsDescrambler::CEsProcessor::~CEsProcessor()
{
	// QƃJEg폜
	m_pEcmProcessor->ReleaseRef();
}

const bool CTsDescrambler::CEsProcessor::StorePacket(const CTsPacket *pPacket)
{
	// XNu
	m_pEcmProcessor->DescramblePacket(const_cast<CTsPacket *>(pPacket));

	return false;
}

void CTsDescrambler::CEsProcessor::OnPidUnmapped(const WORD wPID)
{
	// CX^XJ
	delete this;
}
