// MediaDecoder.h: CMediaDecoder NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#pragma once


#include "MediaData.h"


//////////////////////////////////////////////////////////////////////
// fBAfR[_NX
//////////////////////////////////////////////////////////////////////

class CDecoderHandler;

class CMediaDecoder  
{
public:
	CMediaDecoder(CDecoderHandler *pDecoderHandler);
	virtual ~CMediaDecoder();

	virtual void Reset(void);

	virtual const DWORD GetInputNum(void) const = 0;
	virtual const DWORD GetOutputNum(void) const = 0;

	virtual const bool SetOutputDecoder(CMediaDecoder *pDecoder, const DWORD dwOutputIndex = 0UL, const DWORD dwInputIndex = 0UL);
	virtual const bool InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex = 0UL) = 0;

protected:
	virtual const bool OutputMedia(CMediaData *pMediaData, const DWORD dwOutptIndex = 0UL);
	virtual const DWORD SendDecoderEvent(const DWORD dwEventID, PVOID pParam = NULL);

	// o̓sf[^x[X
	struct TAG_OUTPUTDECODER
	{
		CMediaDecoder *pDecoder;
		DWORD dwInputIndex;
	} m_aOutputDecoder[16];

	CDecoderHandler *m_pDecoderHandler;
};


//////////////////////////////////////////////////////////////////////
// fBAfR[_CxgnhC^tF[X
//////////////////////////////////////////////////////////////////////

class CDecoderHandler
{
friend CMediaDecoder;

protected:
	virtual const DWORD OnDecoderEvent(CMediaDecoder *pDecoder, const DWORD dwEventID, PVOID pParam);
};
