// TsPacketParser.cpp: CTsPacketParser NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TsPacketParser.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


#define TS_HEADSYNCBYTE		(0x47U)


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////


CTsPacketParser::CTsPacketParser(CDecoderHandler *pDecoderHandler)
	: CMediaDecoder(pDecoderHandler)
	, m_bOutputNullPacket(false)
	, m_dwInputPacketCount(0UL)
	, m_dwOutputPacketCount(0UL)
	, m_dwErrorPacketCount(0UL)
{
	// pPbgAJE^
	::FillMemory(m_abyContCounter, sizeof(m_abyContCounter), 0x10UL);
}

CTsPacketParser::~CTsPacketParser()
{

}

void CTsPacketParser::Reset(void)
{
	// pPbgJE^NA
	m_dwInputPacketCount =	0UL;
	m_dwOutputPacketCount = 0UL;
	m_dwErrorPacketCount =	0UL;

	// pPbgAJE^
	::FillMemory(m_abyContCounter, sizeof(m_abyContCounter), 0x10UL);

	// ԂZbg
	m_TsPacket.ClearSize();
	
	CMediaDecoder::Reset();
}

const DWORD CTsPacketParser::GetInputNum(void) const
{
	return 1UL;
}

const DWORD CTsPacketParser::GetOutputNum(void) const
{
	return 1UL;
}

const bool CTsPacketParser::InputMedia(CMediaData *pMediaData, const DWORD dwInputIndex)
{
	if(dwInputIndex >= GetInputNum())return false;
	if(!pMediaData)return false;

	// TSpPbg
	SyncPacket(pMediaData->GetData(), pMediaData->GetSize());

	return true;
}

void CTsPacketParser::SetOutputNullPacket(const bool bEnable)
{
	// NULLpPbg̏o͗Lݒ肷
	m_bOutputNullPacket = (bEnable)? true : false;
}

const DWORD CTsPacketParser::GetInputPacketCount(void) const
{
	// ̓pPbgԂ
	return m_dwInputPacketCount;
}

const DWORD CTsPacketParser::GetOutputPacketCount(void) const
{
	// o̓pPbgԂ
	return m_dwOutputPacketCount;
}

const DWORD CTsPacketParser::GetErrorPacketCount(void) const
{
	// G[pPbgԂ
	return m_dwErrorPacketCount;
}

void inline CTsPacketParser::SyncPacket(const BYTE *pData, const DWORD dwSize)
{
	// ̕@͊Sł͂ȂAꂽꍇɑOĂяõf[^܂ł̂ڂĂ͍ē͂łȂ
	DWORD dwCurSize = 0UL;
	DWORD dwCurPos = 0UL;

	while(dwCurPos < dwSize){
		dwCurSize = m_TsPacket.GetSize();

		if(!dwCurSize){
			// oCg҂
			for( ; dwCurPos < dwSize ; dwCurPos++){
				if(pData[dwCurPos] == TS_HEADSYNCBYTE){
					// oCg
					m_TsPacket.AddByte(TS_HEADSYNCBYTE);
					dwCurPos++;
					break;
					}				
				}
			
			continue;
			}
		else  if(dwCurSize == TS_PACKETSIZE){
			// pPbgTCYf[^

			if(pData[dwCurPos] == TS_HEADSYNCBYTE){
				// ̃f[^͓oCg
				ParsePacket();
				}
			else{
				// G[
				m_TsPacket.ClearSize();				
				
				// ʒuɖ߂
				if(dwCurPos >= (TS_PACKETSIZE - 1UL))dwCurPos -= (TS_PACKETSIZE - 1UL);
				else dwCurPos = 0UL;
				}

			continue;
			}
		else{
			// f[^҂
			if((dwSize - dwCurPos) >= (TS_PACKETSIZE - dwCurSize)){
				m_TsPacket.AddData(&pData[dwCurPos], TS_PACKETSIZE - dwCurSize);
				dwCurPos += (TS_PACKETSIZE - dwCurSize);
				}	
			else{
				m_TsPacket.AddData(&pData[dwCurPos], dwSize - dwCurPos);
				dwCurPos += (dwSize - dwCurPos);
				}			
			
			continue;
			}
		}
}

void inline CTsPacketParser::ParsePacket(void)
{
	// pPbg͂
	m_TsPacket.ParseHeader();

	// pPbg`FbN
	if(m_TsPacket.CheckPacket(&m_abyContCounter[m_TsPacket.GetPID()])){
		// ̓JEgCNg
		if(m_dwInputPacketCount < 0xFFFFFFFFUL)m_dwInputPacketCount++;

		// ̃fR[_Ƀf[^n
		if(m_bOutputNullPacket || (m_TsPacket.GetPID() != 0x1FFFU)){
			
			// o̓JEgCNg
			if(m_dwOutputPacketCount < 0xFFFFFFFFUL)m_dwOutputPacketCount++;
			
			OutputMedia(&m_TsPacket);
			}
		}
	else{
		// G[JEgCNg
		if(m_dwErrorPacketCount < 0xFFFFFFFFUL)m_dwErrorPacketCount++;
		}

	// TCYNÃXgAɔ
	m_TsPacket.ClearSize();
}
