#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import os
import configreader
import glob
import time
import sqlite3
dbpath=str(os.path.dirname(os.path.abspath(__file__)))+"/"+"ch.db"
if __name__ == "__main__":
    print "Hello Rec10 Recording Que Search.";
def search_b25(path):
    """
    録画フォルダを検索し、各QUEの実行状況を表示する
    """
    b25list=glob.glob(path+"/*.b25")
    tslist=glob.glob(path+"/*.ts")
    avilist=glob.glob(path+"/*.avi")
    for b25f in b25list:
        ##b25f is title.ts.b25  avi is title.avi
        dir=os.path.split(b25f)[0]
        title=os.path.split(b25f)[1]
        title=title.replace(".ts.b25","")
        avipath=os.path.join(dir,title+".avi")
        tspath=os.path.join(dir,title+".ts")
        b25f=b25f.replace(".ts.b25",".avi")
        mode="ts"
        if os.path.isfile(tspath):##tsファイルが存在している
            dtime=time.time()-os.path.getmtime(tspath)
            dtime=int(dtime)
            if dtime > 120 :
                if os.path.getsize(tspath)>1*1000*1000:##最終更新から22分以上経過かつ1MB以上
                    mode="avi"
                else:
                    mode="tsmiss"
            else :
                mode="ts"
        if os.path.isfile(avipath):##tsファイルが存在している
            dtime=time.time()-os.path.getmtime(avipath)
            dtime=int(dtime)
            if dtime > 120 :
                if os.path.getsize(avipath)>1*1000*1000:##最終更新から22分以上経過かつ1MB以上
                    mode="fin"
                else:
                    mode="avimiss"
            else :
                mode="avi"
        print title+":"+mode
def search_b25_DB(path):
    """
    検索結果をDBに書き込む。
    """
    db = sqlite3.connect(dbpath)
    try:
        db.execute('drop table que')
        db.commit()
    except:
        test = ""

    try:
        db.execute('create table que (title TEXT,que TEXT,status TEXT)')
    except:
        ""
    db.commit()
    
    b25list=glob.glob(path+"/*.b25")
    tslist=glob.glob(path+"/*.ts")
    avilist=glob.glob(path+"/*.avi")
    for b25f in b25list:
        ##b25f is title.ts.b25  avi is title.avi
        dir=os.path.split(b25f)[0]
        title=os.path.split(b25f)[1]
        title=title.replace(".ts.b25","")
        avipath=os.path.join(dir,title+".avi")
        tspath=os.path.join(dir,title+".ts")
        b25f=b25f.replace(".ts.b25",".avi")
        mode="ts"
        if os.path.isfile(tspath):##tsファイルが存在している
            dtime=time.time()-os.path.getmtime(tspath)
            dtime=int(dtime)
            if dtime > 120 :
                if os.path.getsize(tspath)>1*1000*1000:##最終更新から22分以上経過かつ1MB以上
                    mode="avi"
                else:
                    mode="tsmiss"
            else :
                mode="ts"
        if os.path.isfile(avipath):##tsファイルが存在している
            dtime=time.time()-os.path.getmtime(avipath)
            dtime=int(dtime)
            if dtime > 120 :
                if os.path.getsize(avipath)>1*1000*1000:##最終更新から22分以上経過かつ1MB以上
                    mode="fin"
                else:
                    mode="avimiss"
            else :
                mode="avi"
        print title+":"+mode
path=configreader.getpath("recpath")
search_b25(path)
        