#ifndef SDT_H
#define SDT_H 1

#include <stdio.h>
#include <stdlib.h>

#include "util.h"
#include "ts_ctl.h"

typedef struct _SDThead {
	char table_id;
	int  section_syntax_indicator;
	int  reserved_future_use1;
	int  reserved1;
	int  section_length;
	int  transport_stream_id;
	int  reserved2;
	int  version_number;
	int  current_next_indicator;
	int  section_number;
	int  last_section_number;
	int  original_network_id;
	int  reserved_future_use2;
} SDThead;

typedef struct _SDTbody {
	int  service_id;
	int  reserved_future_use1;
	int  EIT_user_defined_flags;
	int  EIT_schedule_flag;
	int  EIT_present_following_flag;
	int  running_status;
	int  free_CA_mode;
	int  descriptors_loop_length;
} SDTbody;

typedef struct _SVCdesc {
	int  descriptor_tag;
	int  descriptor_length;
	int  service_type;
	int  service_provider_name_length;
	char service_provider_name[MAXSECLEN];
	int  service_name_length;
	char service_name[MAXSECLEN];
} SVCdesc;

typedef struct _LOGdesc {
	int  descriptor_tag;
	int  descriptor_length;
	int  logo_transmission_type;
	int  reserved_future_use1;
	int  logo_id;
	int  reserved_future_use2;
	int  logo_version;
	int  download_data_id;

	char logo_char[MAXSECLEN];
} LOGdesc;

typedef struct _TAG_LOGO
{
	void	*logo;
	int		logo_size;
} LOGO;

typedef struct _TAG_STATION
{
	char	*name;
	char	*ontv;
	int		tsId;		// OriginalNetworkID
	int		onId;		// TransportStreamID
	int		svId;		// ServiceID
	unsigned int	logo_download_data_id;
	LOGO	logo_array[6];
} STATION;

#ifdef __cplusplus
extern "C"{
#endif /* __cplusplus */

	int parseSDThead(unsigned char *data, SDThead *h);
	int parseSDTbody(unsigned char *data, SDTbody *b);
	int parseSVCdesc(unsigned char *data, SVCdesc *desc);
	void dumpSDT(unsigned char *ptr, SVT_CONTROL *top, STATION **station, int * station_count, char *ontvheader);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
