#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import chdb
import rec10d
import recdb
"""
task names
"""
global REC_RESERVE
global REC_FINAL_RESERVE
global REC_ENCODE_GRID
global REC_ENCODE_LOCAL
global REC_ENCODE_QUE
global REC_MISS_ENCODE
global REC_KEYWORD
global REC_KEYWORD_EVERY_SOME_DAYS
global REC_FIN_LOCAL
global REC_MISS_DECODE
global REC_TS_DECODE_QUE
global REC_TS_DECODING
global REC_TS_RECORDING
global REC_AVI_TO_MKV
global REC_AVI_TO_MP4
global REC_MKV_TO_MP4
global REC_CHANGING_CANTAINER

#ここから処理のちに移動
global REC_MOVE_AFTER_RECORD
global REC_MOVE_AFTER_RECORD_FINAL
global REC_MOVE_AFTER_RECORD_RECORDING
global REC_MOVE_AFTER_DECODE
global REC_MOVE_AFTER_DECODE_FINAL
global REC_MOVE_AFTER_DECODE_RECORDING
global REC_MOVE_AFTER_DECODE_DECODE_QUE
global REC_MOVE_AFTER_DECODE_DECODING
global REC_MOVE_AFTER_ENCODE
global REC_MOVE_AFTER_ENCODE_FINAL
global REC_MOVE_AFTER_ENCODE_RECORDING
global REC_MOVE_AFTER_ENCODE_DECODE_QUE
global REC_MOVE_AFTER_ENCODE_DECODING
global REC_MOVE_AFTER_ENCODE_ENCODE_QUE
global REC_MOVE_AFTER_ENCODE_ENCODING
global REC_MOVE_END

#ここから自動で提起される処理。
global REC_AUTO_SUGGEST_REC
global REC_AUTO_SUGGEST_DECODE
global REC_AUTO_SUGGEST_ENCODE
global REC_AUTO_SUGGEST_AVI2MP4
global REC_AUTO_SUGGEST_MKV2MP4
global REC_BAYES_SUGGEST
global REC_AUTO_KEYWORD
REC_RESERVE = "reserve_flexible"
REC_FINAL_RESERVE = "reserve_fixed"
REC_ENCODE_GRID = "convert_ts_mp4_network"
REC_ENCODE_LOCAL = "convert_ts_mp4_running"
REC_ENCODE_QUE = "convert_ts_mp4"
REC_MISS_ENCODE = "convert_avi_mp4_miss"
REC_KEYWORD = "search_today"
REC_KEYWORD_EVERY_SOME_DAYS = "search_everyday"
REC_FIN_LOCAL = "convert_ts_mp4_finished"
REC_MISS_DECODE = "convert_b25_ts_miss"
REC_TS_DECODE_QUE = "convert_b25_ts"
REC_TS_DECODING = "convert_b25_ts_running"
REC_TS_RECORDING = "reserve_running"
REC_CHANGING_CANTAINER = "convert_mkv_mp4_runnings"
REC_AVI_TO_MKV = "convert_avi_mkv"
REC_AVI_TO_MP4 = "convert_avi_mp4"
REC_MKV_TO_MP4 = "convert_mkv_mp4"

REC_MOVE_AFTER_RECORD = "move_rec"
REC_MOVE_AFTER_RECORD_FINAL = "move_rec_final"
REC_MOVE_AFTER_RECORD_RECORDING ="move_rec_recording"
REC_MOVE_AFTER_DECODE = "move_dec"
REC_MOVE_AFTER_DECODE_FINAL = "move_dec_final"
REC_MOVE_AFTER_DECODE_RECORDING = "move_dec_recording"
REC_MOVE_AFTER_DECODE_DECODE_QUE ="move_dec_que"
REC_MOVE_AFTER_DECODE_DECODING = "move_dec_decoding"
REC_MOVE_AFTER_ENCODE = "move_enc"
REC_MOVE_AFTER_ENCODE_FINAL = "move_enc_final"
REC_MOVE_AFTER_ENCODE_RECORDING = "move_enc_recording"
REC_MOVE_AFTER_ENCODE_DECODE_QUE = "move_enc_decque"
REC_MOVE_AFTER_ENCODE_DECODING = "move_enc_decoding"
REC_MOVE_AFTER_ENCODE_ENCODE_QUE = "move_enc_encque"
REC_MOVE_AFTER_ENCODE_ENCODING = "move_enc_encoding"
REC_MOVE_END = "move_end"

REC_AUTO_SUGGEST_REC = "auto_suggest_rec"
REC_AUTO_SUGGEST_DECODE = "auto_suggest_dec"
REC_AUTO_SUGGEST_ENCODE = "auto_suggest_enc"
REC_AUTO_SUGGEST_AVI2MP4 = "auto_suggest_a24"
REC_AUTO_SUGGEST_MKV2MP4 = "auto_suggest_m24"
REC_AUTO_KEYWORD = "auto_keyword"
REC_BAYES_SUGGEST ="bayes_suggest"

def recreserv(title, chtxt, btime, etime, opt):#optにはa(アニメ)d(副音声)v(xvid)
    rec_reckey("res", title, chtxt, btime, etime, opt)
def auto_keyreserv(keyword, chtxt, btime, etime, deltatime, opt):
    rec10d.rec10db.add_timeline(type=recdb.REC_AUTO_KEYWORD, chtxt=chtxt, title=keyword, btime=btime, etime=etime, deltatime=deltatime, opt=opt)
def keyreserv(keyword, chtxt, btime, etime, deltatime, opt):
    rec10d.rec10db.add_timeline(type=recdb.REC_KEYWORD, chtxt=chtxt, title=keyword, btime=btime, etime=etime, deltatime=deltatime, opt=opt)
def everyreserv(keyword, chtxt, btime, etime, deltatime, opt, deltaday):
    rec10d.rec10db.add_timeline(type=recdb.REC_KEYWORD_EVERY_SOME_DAYS, chtxt=chtxt, title=keyword, btime=btime, etime=etime, deltatime=deltatime, opt=opt, deltaday=deltaday)
def rec_reckey(type, title, chtxt, btime, etime, opt):
    rec10d.rec10db.add_timeline(type=type, chtxt=chtxt, title=title, btime=btime, etime=etime, opt=opt)
def del_reckey(type, title, chtxt, btime):
    rec10d.rec10db.del_timeline(type=type, title=title, chtxt=chtxt, btime=btime)
def add_auto_keyword(chtxt,title,btime,etime):
    rec10d.rec10db.add_auto_timeline_keyword(chtxt, title, btime, etime)
def add_auto_bayes(chtxt,title,btime,etime):
    rec10d.rec10db.add_auto_timeline_bayes(chtxt, title, btime, etime)
def getnow(dhour):
    dhour = int(dhour)
    dminutes = 60 * dhour
    dminutes = str(dminutes)
    return rec10d.rec10db.select_bytime_timeline(dminutes)
def getnow_minutes(dminutes):
    return rec10d.rec10db.select_bytime_timeline(dminutes)
def countRecNow(dhour):
    d = getnow(dhour)
    ret = 0
    for i in d:
        t = i['type']
        if t == "key" or t == "keyevery" or t == "rec" or t == "res":
            ret = ret + 1
    return ret
def countRecNow_minutes(dminutes):
    d = getnow_minutes(dminutes)
    ret = 0
    for i in d:
        t = i['type']
        if t == "key" or t == "keyevery" or t == "rec" or t == "res":
            ret = ret + 1
    return ret
def countRecNow_minutes_BSCS(dminutes):
    d = getnow_minutes(dminutes)
    ret = 0
    for i in d:
        t = i['type']
        if t == "key" or t == "keyevery" or t == "rec" or t == "res":
            if len(chdb.chtxtsearch(i['chtxt'])['ch']) > 2:
                ret = ret + 1
    return ret
def countRecNow_minutes_TE(dminutes):
    d = getnow_minutes(dminutes)
    ret = 0
    for i in d:
        t = i['type']
        if t == "key" or t == "keyevery" or t == "rec" or t == "res":
            if len(chdb.chtxtsearch(i['chtxt'])['ch']) < 3:
                ret = ret + 1
    return ret
def delete_old(dhour):
    """
    delete keys except recdb.REC_MISS_ENCODE and recdb.REC_KEYWORD_EVERY_SOME_DAYS before dhour hours from now.
    """
    rec10d.rec10db.delete_old_timeline(dhour)
def delete_old_auto_keyword(dhour):
    rec10d.rec10db.delete_old_auto_timeline_keyword(dhour)
def delete_old_auto_bayes(dhour):
    rec10d.rec10db.delete_old_auto_timeline_bayes(dhour)
def getall():
    return rec10d.rec10db.select_all_timeline()
def rec_reclog(title,chtxt,btime,etime,opt,exp,longexp,category):
    rec10d.rec10db.add_in_timeline_log(chtxt,title,btime,etime,opt,exp,longexp,category)
def get_key():
    return rec10d.rec10db.select_all_in_auto_jbk_key()