#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2011 Yukikaze

"""
task names
"""
import datetime
import os
import os.path
import traceback

import configreader

global REC_RESERVE
global REC_FINAL_RESERVE
global REC_ENCODE_GRID
global REC_ENCODE_LOCAL
global REC_ENCODE_QUE
global REC_MISS_ENCODE
global REC_KEYWORD
global REC_KEYWORD_EVERY_SOME_DAYS
global REC_FIN_LOCAL
global REC_MISS_DECODE
global REC_TS_DECODE_QUE
global REC_TS_DECODING
global REC_TS_RECORDING
global REC_AVI_TO_MKV
global REC_AVI_TO_MP4
global REC_MKV_TO_MP4
global REC_CHANGING_CANTAINER

#ここから処理のちに移動

global REC_MOVE_END

#ここから自動で提起される処理。
global REC_AUTO_SUGGEST_REC
global REC_AUTO_SUGGEST_DECODE
global REC_AUTO_SUGGEST_ENCODE
global REC_AUTO_SUGGEST_AVI2MP4
global REC_AUTO_SUGGEST_MKV2MP4
global REC_AUTO_SUGGEST_AVI2FP
global REC_AUTO_SUGGEST_AP2FP
global REC_BAYES_SUGGEST
global REC_AUTO_KEYWORD
REC_RESERVE = "reserve_flexible"
REC_FINAL_RESERVE = "reserve_fixed"
REC_ENCODE_GRID = "convert_ts_mp4_network"
REC_ENCODE_LOCAL = "convert_ts_mp4_running"
REC_ENCODE_QUE = "convert_ts_mp4"
REC_MISS_ENCODE = "convert_avi_mp4_miss"
REC_KEYWORD = "search_today"
REC_KEYWORD_EVERY_SOME_DAYS = "search_everyday"
REC_FIN_LOCAL = "convert_ts_mp4_finished"
REC_MISS_DECODE = "convert_b25_ts_miss"
REC_TS_DECODE_QUE = "convert_b25_ts"
REC_TS_DECODING = "convert_b25_ts_running"
REC_TS_RECORDING = "reserve_running"
REC_CHANGING_CANTAINER = "convert_mkv_mp4_runnings"
REC_AVI_TO_MKV = "convert_avi_mkv"
REC_AVI_TO_MP4 = "convert_avi_mp4"
REC_MKV_TO_MP4 = "convert_mkv_mp4"

REC_MOVE_END = "move_end"

REC_AUTO_SUGGEST_REC = "auto_suggest_rec"
REC_AUTO_SUGGEST_DECODE = "auto_suggest_dec"
REC_AUTO_SUGGEST_ENCODE = "auto_suggest_enc"
REC_AUTO_SUGGEST_AVI2FP = "auto_suggest_avi2fp"
REC_AUTO_SUGGEST_AP2FP = "auto_suggest_ap2fp"
REC_AUTO_KEYWORD = "auto_keyword"
REC_BAYES_SUGGEST ="bayes_suggest"

global BONTSDEMUX_DELAY
BONTSDEMUX_DELAY="0"

version = 100
version_str="0.9.10"

global verbose_level_now
global log_level_now

try:
    log_level_now=int(configreader.getConfLog("log_level"))
    verbose_level_now=int(configreader.getConfLog("verbose_level"))
except:
    log_level_now=900
    verbose_level_now=400
def printutf8(unicode,verbose_level=500):
    if verbose_level_now > verbose_level:
        try:
            str=unicode.encode('utf-8')
            print str
        except Exception, inst:
            recdblist.addCommonlogEX("Error", "printutf8(recdblist.py)", str(type(inst)), str(inst)+traceback.format_exc(),log_level=200)
def printuft8ex(unicode,verbose_level=500,log_level=500):
    str=unicode.encode('utf-8')
    if verbose_level_now > verbose_level:
        print str
    logfname="/var/log/rec10"
    mode="a"
    if log_level_now > log_level:
        if os.path.exists(logfname):
            f=open(logfname,mode)
            f.write(str+"\n")
            f.close()
def addCommonlogEX(type,place,inst,txt,verbose_level=500,log_level=500):
    lt=datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")+u":"
    if txt=="":
        lt=lt+u"["+type+u"] "+place+u" "+inst
    else:
        lt=lt+u"["+type+u"] "+place+u" "+inst+u"\n"+txt
    lt=lt.encode('utf-8')
    logfname="/var/log/rec10"
    mode="a"
    if verbose_level_now > verbose_level:
        print lt
    if log_level_now > log_level:
        if os.path.exists(logfname):
            f=open(logfname,mode)
            f.write(lt+"\n")
            f.close()
def addCommandLog(tspath,log_title,cmd,cmd_log=""):
    addLog(tspath,cmd,log_title+u"ログ-コマンド")
    addLog(tspath,cmd_log,log_title+u"ログ-詳細")
def addCommandLogZip(tspath,log_title,log_filename_add,cmd,cmd_log=""):
    logtitle=getLogTitle(tspath)
    logo=logtitle+"."+log_filename_add+".log"
    logzip=logtitle+".log.zip"
    addLogAll(tspath,cmd+"\n\n"+cmd_log,log_title,logo)
    import zip
    zip.addFile2FileZip(logo,logzip)
    os.remove(logo)
def addCommandSelfLog(tspath,command):
    logpath=getLogTitle(tspath)+".command.log"
    f=""
    if os.path.exists(logpath):
        f=open(logpath,'a')
    else:
        f=open(logpath,'w')
    tc=command+u"\n\n"
    tc=unicode(tc)
    f.write(tc.encode("utf-8"))
    #f.write(tc.encode('utf-8','ignore'))
    f.close()
def getLogTitle(tspath):
    logo=tspath
    logo=logo.replace("_1.wav",".ts")
    logo=logo.replace("_2.wav",".ts")
    logo=logo.replace("_1.aac",".ts")
    logo=logo.replace("_2.aac",".ts")
    logo=logo.replace("_1.mp3",".ts")
    logo=logo.replace("_2.mp3",".ts")
    logo=logo.replace(".ts.tsmix",".ts")
    logo=logo.replace(".ts.b25",".ts")
    logo=logo.replace(".sa.avi",".ts")
    logo=logo.replace(".m2v",".ts")
    logo=logo.replace(".avi",".ts")
    logo=logo.replace(".mkv",".ts")
    logo=logo.replace(".wav",".ts")
    logo=logo.replace(".mp4",".ts")
    logo=logo.replace(".mp3",".ts")
    logo=logo.replace(".aac",".ts")
    logo=logo.replace(".srt",".ts")
    logo=logo.replace(".264",".ts")
    logo=logo.replace(".ts","")
    return logo
def addLog(tspath,txt,log_title,maxtextlength=1500):
    logo=getLogTitle(tspath)+".log"
    f=open(logo,'a')
    s=len(txt)
    stxt=""
    if s>maxtextlength*2 and maxtextlength>0:
        stxt=txt[0:maxtextlength]+"\n\n(ry..)\n"
        st=txt[s-maxtextlength:].find("\n")
        if st>0:
            stxt=stxt+txt[s-1500+st:]
    else:
        stxt=txt
    txtw= datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    txtw=txtw+"\n####"+log_title+"####\n"+stxt
    f.write(txtw.encode('utf-8'))
    f.close()
def addLogAll(tspath,txt,log_title,logpath):
    logo=logpath
    f=open(logo,'a')
    s=len(txt)
    stxt=txt
    txtw= datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    txtw=txtw+"\n####"+log_title+"####\n"+stxt
    f.write(txtw.encode('utf-8'))
    f.close()
