#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2011 Yukikaze
import os
import os.path
import time
import commands
import traceback

import chdb
import rec10d
import configreader
import recdblist
import tv2ts
tmppath = configreader.getConfPath("tmp")+"/"
tssplitterp = configreader.getConfPath("tssplitter")
def searchCh():
    #地上デジタル
    for i in xrange(13,62):
        recdblist.printuft8ex(u"チャンネルスキャン:地上デジタル CH "+str(i), 200, 200)
        if checkTs(str(i))>0:
            addCh(str(i),u"te"+str(i),str(i))
    #BSデジタル
    recdblist.printuft8ex(u"チャンネルスキャン:BSデジタル "+str(i), 200, 200)
    for i in xrange(100,240):
        recdblist.printuft8ex(u"チャンネルスキャン:BSデジタル CH "+str(i), 200, 200)
        if checkTs(str(i))>0:
            addCh(str(i),u"bs","BS")
    #スカパーe2!
    #http://www5e.biglobe.ne.jp/~kazu_f/digital-sat/trapon-nsat110.html
    #
    #CS1ネットワーク
    if checkTs("CS2")>0:
        addCh("CS2","cs1","CS")
    if checkTs("CS8")>0:
        addCh("CS8","cs1","CS")
    if checkTs("CS10")>0:
        addCh("CS10","cs1","CS")
    #CS2ネットワーク
    if checkTs("CS4")>0:
        addCh("CS4","cs2","CS")
    if checkTs("CS6")>0:
        addCh("CS6","cs2","CS")
    if checkTs("CS12")>0:
        addCh("CS12","cs2","CS")
    if checkTs("CS14")>0:
        addCh("CS14","cs2","CS")
    if checkTs("CS16")>0:
        addCh("CS16","cs2","CS")
    if checkTs("CS18")>0:
        addCh("CS18","cs2","CS")
    if checkTs("CS20")>0:
        addCh("CS20","cs2","CS")
    if checkTs("CS22")>0:
        addCh("CS22","cs2","CS")
    if checkTs("CS24")>0:
        addCh("CS24","cs2","CS")
def checkTs(ch):
    tv2ts.tv2b25ts(os.path.join(tmppath,"ch_"+str(ch)+".ts"), ch, "1")
    if os.path.exists(os.path.join(tmppath,"ch_"+str(ch)+".ts")):
        os.remove(os.path.join(tmppath,"ch_"+str(ch)+".ts"))
        return 1
    else:
        return 0
def addCh(ch,bctype,chtxthead):
    prglist=getChProgNum(ch)##[prglist,logt]
    for lstr in prglist[0]:
        #print [bctype,chtxthead+"_"+lstr, ch, lstr]
        try:
            if ch.find("bs")>-1:
                if int(lstr)<300:
                    rec10d.rec10db.add_epg_ch(bctype,chtxthead+"_"+lstr, ch, lstr, u"2010-01-01 00:00:00")
            else:
                rec10d.rec10db.add_epg_ch(bctype,chtxthead+"_"+lstr, ch, lstr, u"2010-01-01 00:00:00")
        except Exception, inst:
            recdblist.addCommonlogEX("Warning", "addCh (scan_ch.py)", str(type(inst)),str(inst)+traceback.format_exc(),log_level=200)
    checkB25Purchased(ch, prglist[1])
def getChProgNum(ch):
    pout=os.path.join(tmppath,"ch_"+str(ch)+".ts")
    logt=tv2ts.tv2tsmix(pout, ch, "10")
    retl=getTsProgNum(ch,pout)
    os.remove(pout)
    return [retl,logt]
def getTsProgNum(ch,tspath):
    pin=tspath
    pout=os.path.join(tmppath,"chscan.txt")
    chopt="-ch"
    if ch.find("CS")>-1:
        chopt="-cs"
    elif int(ch)>99:
        chopt="-bs"
    doexe = tssplitterp + " "+chopt+" \""+ pin + "\" \""+ pout + "\""
    doexe = "nice -n 18 " + doexe
    os.environ['LANG']="ja_JP.UTF-8"
    txt = unicode(commands.getoutput(doexe.encode('utf-8')),'utf-8','ignore')
    f=open(pout)
    lines=f.readlines()
    f.close()
    ret=[]
    for l in lines:
        try:
            l=l.replace(" ","")
            l=l.replace("\n","")
            ret.append(str(int(l)))
        except:
            ""
    recdblist.addLog(pin, doexe, u"TsSplitログ-コマンド")
    recdblist.addLog(pin, txt, u"TsSplitログ-詳細")
    time.sleep(1)
    try:
        ""
        #os.remove(pout)
    except:
        ""
    return ret
def getB25UnparchasedList(logtxt):
    warning = 0
    ret=[]
    for strt in logtxt.splitlines():
        if strt.find("unpurchased ECM")>-1:
            warning=1
        if strt.find("total TS packet")>-1 and warning>0:
            warning=0
        if strt.find("channel")>-1 and warning>0:
            txt=strt.replace("channel:","")
            txt=txt.replace("\n","")
            txt=txt.replace(" ","")
            ret.append(txt)
    return ret
def checkB25Purchased(ch,logtxt):
    chlists=chdb.searchAllCHFromCh(ch)
    upl=getB25UnparchasedList(logtxt)
    if len(upl)>0 and len(chlists)>0:
        for chl in chlists:
            if chl['csch'] in upl:
                chdb.changeCHShow(chl['chtxt'],"0")
