// NCachedFile.cpp: CNCachedFile NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NCachedFile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CNCachedFile::CNCachedFile()
	: CNFile()
	, m_bIsWritable(false)
	, m_pBuff(NULL)
	, m_dwBuffSize(0UL)
	, m_llDataPos(0ULL)
	, m_llDataSize(0ULL)
	, m_llCurPos(0ULL)
{

}

CNCachedFile::~CNCachedFile()
{
	Close();
}

const bool CNCachedFile::Open(LPCTSTR lpszName, const BYTE bFlags, const DWORD dwBuffSize)
{
	if((bFlags & CNFile::CNF_WRITE) && !(bFlags & CNFile::CNF_READ)){
		// CgLbVL
		m_bIsWritable = true;
		}
	else if(!(bFlags & CNFile::CNF_WRITE) && (bFlags & CNFile::CNF_READ) && !(bFlags & CNFile::CNF_NEW)){
		// [hLbVL
		m_bIsWritable = false;
		}
	else{
		// tȎgݍ킹Ή
		::SetLastError(0x00000057UL);	// up[^܂Bv
		return false;
		}

	// t@CI[v
	if(!CNFile::Open(lpszName, bFlags))return false;

	// obt@m
	if(!m_bIsWritable){
		// ǂݍ݃obt@
		m_dwBuffSize = (dwBuffSize <= GetSize())? dwBuffSize : (DWORD)GetSize();
		}

	if(m_pBuff)delete [] m_pBuff;
	m_pBuff = new BYTE [m_dwBuffSize];

	if(!m_pBuff){
		Close();
		::SetLastError(0x0000000EUL);	// ȗ̂ɏ\ȋL̈悪܂Bv
		return false;
		}

	// obt@
	m_llDataPos = 0ULL;
	m_llDataSize = 0ULL;
	m_llCurPos = 0ULL;

	::SetLastError(0x00000000UL);	// u͐ɏI܂Bv

	return true;
}

void CNCachedFile::Close(void)
{
	// ݃f[^tbV
	Flush();

	CNFile::Close();

	if(m_pBuff){
		delete [] m_pBuff;
		m_pBuff = NULL;
		}
}

const bool CNCachedFile::Read(BYTE *pBuff, const DWORD dwLen)
{
	// G[
	if(m_bIsWritable){
		::SetLastError(0x00000001UL);	// usȊ֐łBv
		return false;
		}

	if(!dwLen){
		::SetLastError(0x00000057UL);	// up[^܂Bv
		return false;
		}

	return CNFile::Read(pBuff, dwLen);
}

const bool CNCachedFile::Read(BYTE *pBuff, const DWORD dwLen, const ULONGLONG llPos)
{
	if(m_bIsWritable){
		::SetLastError(0x00000001UL);	// usȊ֐łBv
		return false;
		}

	// t@CV[N
	if(Seek(llPos)){
		return Read(pBuff, dwLen);
		}

	return false;
}

const bool CNCachedFile::Write(const BYTE *pBuff, const DWORD dwLen)
{
	// t@C
	if(!m_bIsWritable){
		::SetLastError(0x00000001UL);	// usȊ֐łBv
		return false;
		}

	if(!dwLen){
		::SetLastError(0x00000057UL);	// up[^܂Bv
		return false;
		}

	// obt@O
	if((m_dwBuffSize - (DWORD)m_llDataSize) <= dwLen){
		// obt@s
		if(!Flush())return false;
		}

	// obt@O
	if((m_dwBuffSize - (DWORD)m_llDataSize) >= dwLen){
		::CopyMemory(m_pBuff + m_llDataSize, pBuff, dwLen);
		m_llDataSize += dwLen;
		}
	else{
		if(!CNFile::Write(pBuff, dwLen, m_llCurPos))return false;
		}

	// t@C|WVXV
	m_llCurPos += (ULONGLONG)dwLen;

	::SetLastError(0x00000000UL);	// u͐ɏI܂Bv

	return true;
}

const bool CNCachedFile::Write(const BYTE *pBuff, const DWORD dwLen, const ULONGLONG llPos)
{
	// t@C
	if(!m_bIsWritable){
		::SetLastError(0x00000001UL);	// usȊ֐łBv
		return false;
		}

	// t@CV[N
	if(Seek(llPos)){
		return Write(pBuff, dwLen);
		}

	return false;
}

const ULONGLONG CNCachedFile::GetPos(void) const
{
	// _Iȃt@C|WVԂ
	return (m_bIsWritable)? m_llCurPos : CNFile::GetPos();
}

const bool CNCachedFile::Seek(const ULONGLONG llPos)
{
	// V[NOɃtbV
	if(!Flush())return false;

	// V[N
	if(!CNFile::Seek(llPos))return false;

	// t@C|WVXV
	m_llCurPos = llPos;
	m_llDataPos = llPos;

	return true;
}

const bool CNCachedFile::Flush(void)
{
	if(!m_bIsWritable || !m_llDataSize)return true;

	// obt@擪ʒuɏ
	if(!CNFile::Write(m_pBuff, (DWORD)m_llDataSize, m_llDataPos))return false;

	// t@C|WV𕜋A
	if(!CNFile::Seek(m_llCurPos))return false;

	// obt@TCYNA
	m_llDataSize = 0ULL;
	m_llDataPos = m_llCurPos;

	return true;
}
