/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.schema.SqlSchema;

public class RelationTernaryOperate extends RelationExpression {

	//
	private RelationTernaryOperator op;
	private RelationExpression pa, pb, pc;

	public RelationTernaryOperate(RelationTernaryOperator o,
			RelationExpression a, RelationExpression b,
			RelationExpression c) {
		op = o;
		pa = a;  pb = b;  pc = c;
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		return op.op(pa.eval(v, f, tuple, m, group, h),
				pb.eval(v, f, tuple, m, group, h),
				pc.eval(v, f, tuple, m, group, h));
	}

	@Override
	public boolean isAggregate() {
		return pa.isAggregate() || pb.isAggregate() ||
				pc.isAggregate();
	}

	@Override
	public Object init(RelationAggregate m) throws SQLException {
		return op.op(pa.init(m), pb.init(m), pc.init(m));
	}

}
