/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

import net.morilib.db.relations.Relation;
import net.morilib.db.schema.SqlSchema;

public class EditorPanel extends JPanel {

	private class TL extends AbstractListModel
	implements ComboBoxModel {

		String sel;

		/* (non-Javadoc)
		 * @see javax.swing.ListModel#getSize()
		 */
		@Override
		public int getSize() {
			try {
				return schema.getTableNames().size();
			} catch(IOException e) {
				return 0;
			} catch(SQLException e) {
				return 0;
			}
		}

		/* (non-Javadoc)
		 * @see javax.swing.ListModel#getElementAt(int)
		 */
		@Override
		public Object getElementAt(int index) {
			Iterator<String> itr;

			try {
				itr = schema.getTableNames().iterator();
				for(int i = 0; itr.hasNext() && i < index; i++) {
					itr.next();
				}
				return itr.next();
			} catch (IOException e) {
				return "(fail to get)";
			} catch (SQLException e) {
				return "(fail to get)";
			}
		}

		/* (non-Javadoc)
		 * @see javax.swing.ComboBoxModel#setSelectedItem(java.lang.Object)
		 */
		@Override
		public void setSelectedItem(Object anItem) {
			sel = anItem.toString();
		}

		/* (non-Javadoc)
		 * @see javax.swing.ComboBoxModel#getSelectedItem()
		 */
		@Override
		public Object getSelectedItem() {
			return sel;
		}

	}

	private SqlSchema schema;
	private JTable table;

	public EditorPanel(SqlSchema f) {
		final JPopupMenu p1;
		final JComboBox c1;
		final JMenuItem i1;

		// initialize
		schema = f;
		setLayout(new BorderLayout());

		// menu
		i1 = new JMenuItem("delete");
		i1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				RelationEditorTableModel r;
				TableModel m;
				int[] a;

				if(e.getSource() == i1) {
					m = table.getModel();
					a = table.getSelectedRows();
					if(m instanceof RelationEditorTableModel) {
						r = (RelationEditorTableModel)m;
						if(JOptionPane.showConfirmDialog(
								table,
								a.length + " rows will be deleted, sure?",
								"delete rows",
								JOptionPane.YES_NO_OPTION
								) == JOptionPane.YES_OPTION) {
							Arrays.sort(a);
							for(int i = a.length - 1; i >= 0; i--) {
								r.deleteTuple(a[i]);
							}
						}
					}
				}
			}

		});
		p1 = new JPopupMenu();
		p1.add(i1);

		table = new JTable();
		table.getSelectionModel()
		.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent e) {
				RelationEditorTableModel r;
				TableModel m;

				m = table.getModel();
				if(m instanceof RelationEditorTableModel) {
					try {
						r = (RelationEditorTableModel)m;
						r.write(schema);
					} catch(IOException e1) {
						e1.printStackTrace();
						JOptionPane.showMessageDialog(EditorPanel.this,
								"",
								"IO error",
								JOptionPane.ERROR_MESSAGE);
					} catch(SQLException e1) {
						e1.printStackTrace();
						JOptionPane.showMessageDialog(EditorPanel.this,
								e1.getMessage(),
								"IO error",
								JOptionPane.ERROR_MESSAGE);
					}
				}
			}

		});
		table.addMouseListener(new MouseListener() {

			@Override
			public void mouseClicked(MouseEvent e) {
				if(SwingUtilities.isRightMouseButton(e)) {
					i1.setEnabled(table.getSelectedRow() >= 0);
					p1.show(e.getComponent(), e.getX(), e.getY());
				}
			}

			@Override
			public void mousePressed(MouseEvent e) {
				// do nothing
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				// do nothing
			}

			@Override
			public void mouseEntered(MouseEvent e) {
				// do nothing
			}

			@Override
			public void mouseExited(MouseEvent e) {
				// do nothing
			}

		});
		add(new JScrollPane(table), BorderLayout.CENTER);

		c1 = new JComboBox(new TL());
		c1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				Relation r;
				String n;

				try {
					n = ((TL)c1.getModel()).sel;
					r = schema.readRelation(n, null);
					table.setModel(new RelationEditorTableModel(n, r));
				} catch(IOException e1) {
					e1.printStackTrace();
					JOptionPane.showMessageDialog(EditorPanel.this,
							"",
							"IO error",
							JOptionPane.ERROR_MESSAGE);
				} catch(SQLException e1) {
					e1.printStackTrace();
					JOptionPane.showMessageDialog(EditorPanel.this,
							e1.getMessage(),
							"IO error",
							JOptionPane.ERROR_MESSAGE);
				}
			}

		});
		add(c1, BorderLayout.NORTH);
	}

}
