/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.DbBool;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public abstract class RelationExpression {

	public static final Object TRUE = Rational.ONE;

	public static final Object TRUE_OUTER = Rational.ONE.negate();

	public static final Object FALSE = Rational.ZERO;

	public static final Object NULL = "";

	public static final Object NONE = new java.io.Serializable() {};

	/**
	 * 
	 * @param a
	 * @param b
	 * @return
	 */
	public static int cmp(Object a, Object b) {
		if(a instanceof Rational && b instanceof Rational) {
			return ((Rational)a).compareTo((Rational)b);
		} else {
			return a.toString().compareTo(b.toString());
		}
	}

	/**
	 * 
	 * @param a
	 * @return
	 */
	public static boolean isNull(Object a) {
		return a == null || a.equals("");
	}

	static DbBool bool(Object o) {
		if(o instanceof DbBool) {
			return (DbBool)o;
		} else if(o instanceof Rational) {
			return ((Rational)o).signum() != 0
					? DbBool.TRUE : DbBool.FALSE;
		} else {
			return !o.equals("") ? DbBool.TRUE : DbBool.FALSE;
		}
	}

	static Object value(DbBool b) {
//		return b ? Rational.ONE : Rational.ZERO;
		switch(b) {
		case FALSE:  return FALSE;
		case TRUE_OUTER:  return TRUE_OUTER;
		case TRUE:  return TRUE;
		default:  throw new RuntimeException();
		}
	}

	static Object value(boolean b) {
		return b ? Rational.ONE : Rational.ZERO;
	}

	public DbBool test(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		return bool(eval(v, f, tuple, m, group, h));
	}

	public abstract Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException;

	public abstract Object init(
			RelationAggregate m) throws SQLException;

	public abstract boolean isAggregate();

}
